const _ = require('lodash');
const log = require('logger');

module.exports = function parseFormFields(body) {
    const formFields = {};

    for (const field of _.keys(body)) {
        const fieldData = body[field];

        try {
            const parsedData = JSON.parse(fieldData);
            const name = _.get(parsedData, 'question.slug', '');

            formFields[name] = _.get(parsedData, 'value');
        } catch (err) {
            log.error('Can not parse body', { err, body });
        }
    }

    return formFields;
};
