const _ = require('lodash');

const assert = require('helpers/assert');

const LOGIN_REGEXP = new RegExp('[-.]+', 'g');

module.exports = {
    getInterval(query) {
        const from = Date.parse(query.from);

        assert(!isNaN(from), 400, 'From date is invalid', 'FND', { from: query.from });

        const to = query.to ? Date.parse(query.to) : Date.now();

        assert(!isNaN(to), 400, 'To date is invalid', 'TND', { to: query.to });

        return { from: new Date(from), to: new Date(to) };
    },

    getArray(query, field) {
        let value = _.defaultTo(query[field], []);

        if (!Array.isArray(value)) {
            value = [value];
        }

        return value;
    },

    getLoginForSearch(query) {
        const { login } = query;

        assert(login && _.isString(login), 400, 'Login is invalid', 'LII', { searchedLogin: login });

        return login.replace(LOGIN_REGEXP, '_');
    }
};
