const koaRouter = require('koa-router');

module.exports = function () {
    const router = koaRouter();

    const route = {};
    const methods = ['get', 'post', 'patch', 'delete'];

    methods.map(method => {
        route[method] = function (...args) {
            const [url, methodName] = args;

            if (!this._controller) {
                throw new Error('Use `router.useController` before call `router[method]`');
            }

            const middlewares = [].slice.call(args, 2);
            const params = []
                .concat(url)
                .concat(middlewares)
                .concat(this._controller[methodName]);

            router[method](...params);

            return this;
        };
    });

    route.useController = function (controller) {
        this._controller = controller;

        return this;
    };

    route.routes = function () {
        return router.routes();
    };

    return route;
};
