const _ = require('lodash');
const config = require('yandex-config');

const { getService } = require('helpers/tankerHelper');

const Blackbox = require('models/blackbox');
const Notifier = require('models/notifier');

module.exports = function *sendLetters(usersData, letterIdentity) {
    const uids = _.map(usersData, 'uid');

    const blackbox = new Blackbox(config.blackbox);
    const emailsByUid = yield blackbox.getEmails(uids);

    for (const { uid, services } of usersData) {
        for (const { code, language } of services) {
            const service = getService(code, language);

            yield Notifier.sendLetterToUser(emailsByUid[uid], letterIdentity, { service });
        }
    }
};
