const config = require('yandex-config').tvm;
const got = require('got');
const _ = require('lodash');
const log = require('logger');
const lru = require('lru-cache');
const cache = lru({ maxAge: config.cache.ticketMaxAge });

const { src } = config;

function *getTvmTicket(dstsData) {
    let res = null;

    try {
        res = yield got(`${config.host}/tickets`, {
            headers: config.headers,
            query: {
                src,
                dsts: dstsData.dsts
            },
            json: true
        });
    } catch (err) {
        log.error('Cannot get tvm ticket: ', err);
        throw err;
    }

    return _.get(res.body, [dstsData.alias, 'ticket']);
}

module.exports = {
    parseTicket: function *parseTicket(ticket) {
        const options = {
            query: { dst: config.appId },
            headers: {
                Authorization: config.token,
                'X-Ya-Service-Ticket': ticket,
                Connection: 'Keep-Alive'
            },
            json: true
        };
        let res = null;

        try {
            res = yield got(`${config.host}/checksrv`, options);
        } catch (err) {
            log.warn(err);

            return { err };
        }

        const ticketSrc = parseInt(_.get(res, 'body.src'), 10);

        return { src: ticketSrc };
    },

    getTicket: function *getTicket(dstsData) {
        if (!dstsData) {
            return Promise.resolve('');
        }

        const { alias } = dstsData;

        if (!cache.has(alias)) {
            const ticket = yield getTvmTicket(dstsData);

            if (ticket) {
                cache.set(alias, ticket);
            }
        }

        return cache.get(alias);
    },

    cache
};
