require('debug-http')();
const path = require('path');
const yandexEnvironment = require('yandex-environment');

process.env.NODE_ENV = yandexEnvironment || 'development';
process.env.NODE_CONFIG_DIR = path.join(__dirname, 'configs');

const config = require('yandex-config');
const app = require('api.js');
const endpoint = config.server.port || config.server.socket;
const log = require('logger');
const health = require('koa-ping');

app.use(health());

app.listen(endpoint, () => {
    log.info('started instance', { endpoint });
});
