const _ = require('lodash');

const yandexLogger = require('@yandex-int/yandex-logger');
const deployStream = require('@yandex-int/yandex-logger/streams/deploy')();
const errSerializer = require(`yandex-logger/middleware/err`)();

function reqSerializer(record) {
    const { req } = record;

    if (!req) {
        return;
    }

    record.req = {
        id: req.id,
        headers: _.omit(req.request.header, ['cookie', 'x-ya-service-ticket']),
        method: req.method,
        ip: req.ip,
        protocol: req.protocol,
        originalUrl: req.originalUrl,
        query: req.query,
        yandexuid: req.cookies.get('yandexuid')
    };
}

function resSerializer(record) {
    const { res } = record;

    if (!res) {
        return;
    }

    record.res = {
        statusCode: res.status,
        responseTime: res.responseTime,
        headers: res.response.header
    };
}

const logger = yandexLogger({
    name: 'expert-api',
    streams: [
        {
            level: process.env.NODE_ENV === 'local' || process.env.NODE_ENV === 'drone' ?
                'fatal' :
                'info',
            stream: deployStream
        }
    ],
    middleware: [
        reqSerializer,
        resSerializer,
        errSerializer
    ]
});

module.exports = logger;

module.exports.sqlLogger = function sqlLogger(sql, time) {
    const message = sql.replace(/'.*?'/g, '\'XXXXX\'');

    logger.info(message, { time });
};
