const _ = require('lodash');

const assert = require('helpers/assert');
const getBanData = require('helpers/getBanData');

module.exports = function *checkUserBan(next) {
    const uid = _.get(this.state, 'user.uid.value');
    const authTypeCode = _.get(this.state, 'authType');
    const login = _.get(this.state, 'user.login');

    if (uid) {
        const {
            isBannedOnTest,
            isSuperBanned,
            actualLogin
        } = yield getBanData(this.params.examIdentity, { uid, authTypeCode });

        assert(!isSuperBanned && !isBannedOnTest, 403, 'User is banned', 'UIB', { uid, authTypeCode });
        assert(!actualLogin || actualLogin === login, 403, 'Login is not actual', 'LAC', { uid, authTypeCode });
    }

    yield next;
};
