const { assign } = require('lodash');

/**
 * Определяем критичность ошибки:
 *     если есть статус код - то это контролируемая ошибка,
 *     нет смысла повторять запрос, уровень `fatal`. Иначе,
 *     можно посторить запрос, уровень 'error'
 *     @see: https://wiki.yandex-team.ru/Intranet/idm/API/#examples
 *
 * @param {Error} err
 * @returns {String}
 */
function getErrorLevel(err) {
    return err.status ? 'fatal' : 'error';
}

module.exports = function *(next) {
    try {
        const data = yield next;

        this.body = assign(data, { code: 0 });
    } catch (err) {
        const errorLevel = getErrorLevel(err);
        const code = err.status || 1;

        this.body = { code, [errorLevel]: err.message };
    }
};
