const config = require('yandex-config');
const _ = require('lodash');

const assert = require('helpers/assert');

module.exports = function *checkKarma(next) {
    const uid = _.get(this.state, 'user.uid.value');

    if (uid) {
        const userKarma = _.get(this.state, 'user.karma.value');

        assert(userKarma < config.minSpamKarma, 403, 'User is spammer', 'UIS', { uid });
    }

    yield next;
};
