const log = require('logger');

function sanitize(data) {
    data = data || '';

    return decodeURIComponent(data).replace(/[;:'".()\\]+/, '');
}

module.exports = function *(next) {
    const uid = this.cookies.get('uid');
    const username = this.cookies.get('username') || '';

    if (/^\d+$/.test(uid) && /^[A-Za-z0-9_]*$/.test(username)) {
        this.state.user = {
            uid: { value: uid },
            firstname: sanitize(this.cookies.get('firstname')),
            lastname: sanitize(this.cookies.get('lastname')),
            username
        };
    } else {
        log.warn('User data contains invalid characters', { uid, username });

        this.state.user = { status: { value: 'INVALID', id: 0 } };
    }

    this.state.authType = 'telegram';

    yield next;
};
