const tvm = require('helpers/tvm');
const config = require('yandex-config');
const assert = require('helpers/assert');

const { TvmClient } = require('db/postgres');

function *checkClientAccess(clientId) {
    const client = yield TvmClient.findOne({
        where: { clientId },
        attributes: ['name']
    });

    assert(client, 403, 'Client has no access', 'CNA');

    return client.name;
}

module.exports = function *checkTvm(next) {
    if (config.skipTvmCheck && !this.header['force-tvm-check']) {
        return yield next;
    }

    const ticket = this.header['x-ya-service-ticket'];

    assert(ticket, 400, 'Ticket is not defined', 'TIN');

    const parsed = yield tvm.parseTicket(ticket);

    assert(parsed.src, 403, 'Cannot parse ticket', 'CPT', { err: parsed.err });

    this.state.tvmClient = yield checkClientAccess(parsed.src);

    yield next;
};
