const Blackbox = require('models/blackbox');
const log = require('logger');
const _ = require('lodash');

function *getUserState(config, options, hasSession) {
    const blackbox = new Blackbox(config);
    const userState = hasSession ?
        yield blackbox.sessionId(options) :
        { status: { value: 'INVALID', id: 0 } };

    if (!_.has(userState, 'uid.value')) {
        log.info('Invalid uid value', {
            options: _.pick(options, ['host', 'userip']),
            userState: _.pick(userState, ['status', 'uid'])
        });
    }

    return userState;
}

module.exports = function (config) {
    return function *(next) {
        try {
            const sessionId = this.cookies.get('Session_id');
            const sslSessionId = this.cookies.get('sessionid2');
            const hasSession = sessionId || sslSessionId;

            const host = this.header.userhost || this.header.host;
            const userip = this.header.userip || this.ip;
            const options = {
                sessionid: sessionId,
                sslsessionid: sslSessionId,
                host: host.replace(/:\d+/, ''),
                userip,
                forceTvmCheck: this.header['force-tvm-check']
            };

            this.state.user = yield getUserState(config, options, hasSession);
            this.state.authType = 'web';
        } catch (err) {
            log.warn('Request to Blackbox was failed', { err });
        }

        yield next;
    };
};
