BEGIN;

-- admins_to_roles
ALTER TABLE admins_to_roles DROP CONSTRAINT admins_to_roles_admin_id_fkey;
ALTER TABLE admins_to_roles ADD CONSTRAINT admins_to_roles_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE admins_to_roles DROP CONSTRAINT admins_to_roles_role_id_fkey;
ALTER TABLE admins_to_roles ADD CONSTRAINT admins_to_roles_role_id_fkey FOREIGN KEY (role_id) REFERENCES roles(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- answers
ALTER TABLE answers DROP CONSTRAINT answers_questions_fk;
ALTER TABLE answers ADD CONSTRAINT answers_questions_fk FOREIGN KEY (question_id, question_version) REFERENCES questions(id, version) ON UPDATE CASCADE ON DELETE RESTRICT;

-- certificates
ALTER TABLE certificates DROP CONSTRAINT certificates_trial_id_fkey;
ALTER TABLE certificates ADD CONSTRAINT certificates_trial_id_fkey FOREIGN KEY (trial_id) REFERENCES trials(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- freezing
ALTER TABLE freezing DROP CONSTRAINT freezing_trial_template_id_fkey;
ALTER TABLE freezing ADD CONSTRAINT freezing_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- proctoring_responses
ALTER TABLE proctoring_responses DROP CONSTRAINT proctoring_responses_trial_id_fkey;
ALTER TABLE proctoring_responses ADD CONSTRAINT proctoring_responses_trial_id_fkey FOREIGN KEY (trial_id) REFERENCES trials(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- proctoring_videos
ALTER TABLE proctoring_videos DROP CONSTRAINT proctoring_videos_trial_id_fkey;
ALTER TABLE proctoring_videos ADD CONSTRAINT proctoring_videos_trial_id_fkey FOREIGN KEY (trial_id) REFERENCES trials(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- questions
ALTER TABLE questions DROP CONSTRAINT questions_section_id_fkey;
ALTER TABLE questions ADD CONSTRAINT questions_section_id_fkey FOREIGN KEY (section_id) REFERENCES sections(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE questions DROP CONSTRAINT questions_category_id_fkey;
ALTER TABLE questions ADD CONSTRAINT questions_category_id_fkey FOREIGN KEY (category_id) REFERENCES categories(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- sections
ALTER TABLE sections DROP CONSTRAINT sections_service_id_fkey;
ALTER TABLE sections ADD CONSTRAINT sections_service_id_fkey FOREIGN KEY (service_id) REFERENCES services(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- trial_template_allowed_fails
ALTER TABLE trial_template_allowed_fails DROP CONSTRAINT trial_template_allowed_fails_section_id_fkey;
ALTER TABLE trial_template_allowed_fails ADD CONSTRAINT trial_template_allowed_fails_section_id_fkey FOREIGN KEY (section_id) REFERENCES sections(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE trial_template_allowed_fails DROP CONSTRAINT trial_template_allowed_fails_trial_template_id_fkey;
ALTER TABLE trial_template_allowed_fails ADD CONSTRAINT trial_template_allowed_fails_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- trial_templates
ALTER TABLE trial_templates DROP CONSTRAINT trial_templates_service_id_fkey;
ALTER TABLE trial_templates ADD CONSTRAINT trial_templates_service_id_fkey FOREIGN KEY (service_id) REFERENCES services(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE trial_templates DROP CONSTRAINT trial_templates_type_id_fkey;
ALTER TABLE trial_templates ADD CONSTRAINT trial_templates_type_id_fkey FOREIGN KEY (type_id) REFERENCES types(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- trial_templates_to_sections
ALTER TABLE trial_templates_to_sections DROP CONSTRAINT trial_templates_to_sections_section_id_fkey;
ALTER TABLE trial_templates_to_sections ADD CONSTRAINT trial_templates_to_sections_section_id_fkey FOREIGN KEY (section_id) REFERENCES sections(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE trial_templates_to_sections DROP CONSTRAINT trial_templates_to_sections_trial_template_id_fkey;
ALTER TABLE trial_templates_to_sections ADD CONSTRAINT trial_templates_to_sections_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE trial_templates_to_sections DROP CONSTRAINT trial_templates_to_sections_category_id_fkey;
ALTER TABLE trial_templates_to_sections ADD CONSTRAINT trial_templates_to_sections_category_id_fkey FOREIGN KEY (category_id) REFERENCES categories(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- trials
ALTER TABLE trials DROP CONSTRAINT trials_trial_template_id_fkey;
ALTER TABLE trials ADD CONSTRAINT trials_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE trials DROP CONSTRAINT trials_user_id_fkey;
ALTER TABLE trials ADD CONSTRAINT trials_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- trials_to_questions
ALTER TABLE trials_to_questions DROP CONSTRAINT trials_to_questions_questions_fk;
ALTER TABLE trials_to_questions ADD CONSTRAINT trials_to_questions_questions_fk FOREIGN KEY (question_id, question_version) REFERENCES questions(id, version) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE trials_to_questions DROP CONSTRAINT trials_to_questions_trials;
ALTER TABLE trials_to_questions ADD CONSTRAINT trials_to_questions_trials FOREIGN KEY (trial_id) REFERENCES trials(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- user_identifications
ALTER TABLE user_identifications DROP CONSTRAINT user_identifications_trial_template_id_fkey;
ALTER TABLE user_identifications ADD CONSTRAINT user_identifications_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE user_identifications DROP CONSTRAINT user_identifications_user_id_fkey;
ALTER TABLE user_identifications ADD CONSTRAINT user_identifications_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- users
ALTER TABLE users DROP CONSTRAINT users_agency_id_fkey;
ALTER TABLE users ADD CONSTRAINT users_agency_id_fkey FOREIGN KEY (agency_id) REFERENCES agencies(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE users DROP CONSTRAINT users_auth_type_id_fkey;
ALTER TABLE users ADD CONSTRAINT users_auth_type_id_fkey FOREIGN KEY (auth_type_id) REFERENCES auth_types(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE users DROP CONSTRAINT users_role_id_fkey;
ALTER TABLE users ADD CONSTRAINT users_role_id_fkey FOREIGN KEY (role_id) REFERENCES roles(id) ON UPDATE CASCADE ON DELETE RESTRICT;

COMMIT;
