-- EXPERTDEV-809 Метазадача: база и фронт для забаненных логинов

-- EXPERTDEV-944: [API] Таблица связки пользователей
CREATE TABLE global_users (
    id BIGSERIAL NOT NULL,
    actual_login CHARACTER VARYING(255) COLLATE "C.UTF-8" NOT NULL,
    is_banned BOOLEAN NOT NULL DEFAULT FALSE,
    is_active BOOLEAN NOT NULL DEFAULT TRUE
);
ALTER TABLE ONLY users ADD COLUMN global_user_id BIGINT;

ALTER TABLE ONLY global_users
    ADD CONSTRAINT global_users_id_pkey PRIMARY KEY (id);
ALTER TABLE ONLY users
    ADD CONSTRAINT users_global_user_id_fkey FOREIGN KEY (global_user_id) REFERENCES global_users (id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- EXPERTDEV-901: Таблица банов, EXPERTDEV-945: [API] Апгрейднуть таблицу банов
CREATE TYPE ban_action_type AS ENUM ('ban', 'unban');

CREATE TABLE bans (
    id SERIAL NOT NULL,
    global_user_id BIGINT NOT NULL,
    admin_id INTEGER NOT NULL,
    trial_template_id INTEGER NOT NULL,
    action ban_action_type NOT NULL,
    started_date TIMESTAMP WITH TIME ZONE NOT NULL,
    expired_date TIMESTAMP WITH TIME ZONE,
    reason TEXT COLLATE "C.UTF-8",
    user_login CHARACTER VARYING(255) COLLATE "C.UTF-8" NOT NULL,
    is_last BOOLEAN NOT NULL DEFAULT FALSE
);

ALTER TABLE ONLY bans
    ADD CONSTRAINT bans_pkey PRIMARY KEY (id);

ALTER TABLE ONLY bans
    ADD CONSTRAINT bans_global_user_id_fkey FOREIGN KEY (global_user_id) REFERENCES global_users(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY bans
    ADD CONSTRAINT bans_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY bans
    ADD CONSTRAINT bans_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins(id) ON UPDATE CASCADE ON DELETE RESTRICT;

CREATE UNIQUE INDEX idx_bans_global_user_id_trial_template_id_is_last_unique
    ON bans (global_user_id, trial_template_id, is_last)
    WHERE is_last = TRUE;

-- EXPERTDEV-913: [API] Аннулировать сертификаты при бане
CREATE TYPE certificate_deactivate_reason_type AS ENUM ('ban', 'rules');

ALTER TABLE certificates ADD COLUMN deactivate_reason certificate_deactivate_reason_type;

UPDATE certificates
SET deactivate_reason = 'rules'
WHERE active = 0;

-- EXPERTDEV-989: [API] Отчет по банам за период и по группе тестов. Управленческая отчетность
ALTER TABLE certificates ADD COLUMN deactivate_date TIMESTAMP WITH TIME ZONE;
