-- Добавляем поля для разделения тестов с прокторингом и без
ALTER TABLE trial_templates ADD COLUMN is_proctoring BOOLEAN DEFAULT false NOT NULL;
ALTER TABLE trial_templates ADD COLUMN cluster_slug VARCHAR(255) COLLATE "C.UTF-8";
UPDATE trial_templates SET cluster_slug = slug;
ALTER TABLE trial_templates ALTER COLUMN cluster_slug SET NOT NULL;

-- EXPERTDEV-498: Унести описания тестов из БД в Бункер
ALTER TABLE trial_templates DROP COLUMN description;
ALTER TABLE trial_templates DROP COLUMN rules;
ALTER TABLE trial_templates DROP COLUMN og_description;
ALTER TABLE trial_templates DROP COLUMN seo_description;

-- EXPERTDEV-490: Возможность сохранять фото пользователя в БД
CREATE TABLE user_identifications (
    user_id BIGINT NOT NULL,
    trial_template_id INTEGER NOT NULL,
    document CHARACTER VARYING(255) COLLATE "C.UTF-8" NOT NULL,
    face CHARACTER VARYING(255) COLLATE "C.UTF-8" NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE NOT NULL,
    updated_at TIMESTAMP WITH TIME ZONE NOT NULL
);
CREATE INDEX user_identification_idx ON user_identifications (user_id, trial_template_id);
ALTER TABLE ONLY user_identifications
    ADD CONSTRAINT user_identifications_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates(id) ON UPDATE CASCADE ON DELETE SET NULL;
ALTER TABLE ONLY user_identifications
    ADD CONSTRAINT user_identifications_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id) ON UPDATE CASCADE ON DELETE SET NULL;

-- EXPERTDEV-523: Отдельная таблица для хранения данных прокторинга
CREATE TYPE source_type AS ENUM ('proctoring', 'toloka', 'appeal');
CREATE TYPE verdict_type AS ENUM ('correct', 'failed', 'pending');

CREATE TABLE proctoring_responses (
    id BIGSERIAL NOT NULL,
    trial_id INTEGER NOT NULL,
    source source_type NOT NULL,
    verdict verdict_type NOT NULL,
    time TIMESTAMP WITH TIME ZONE NOT NULL,
    is_last BOOLEAN NOT NULL
);
ALTER TABLE ONLY proctoring_responses
    ADD CONSTRAINT proctoring_responses_pkey PRIMARY KEY (id);
ALTER TABLE ONLY proctoring_responses
    ADD CONSTRAINT proctoring_responses_trial_id_fkey FOREIGN KEY (trial_id) REFERENCES trials(id) ON UPDATE CASCADE ON DELETE SET NULL;

CREATE UNIQUE INDEX idx_proctoring_responses_trial_id_is_last_unique
    ON proctoring_responses (trial_id, is_last)
    WHERE is_last = TRUE;

-- EXPERTDEV-559: Ручка сбора информации по pending-попыткам для отправки в YT
ALTER TABLE proctoring_responses ADD COLUMN is_sent_to_toloka BOOLEAN DEFAULT false NOT NULL;

-- EXPERTDEV-592: Сохранять uuid сессии прокторинга
ALTER TABLE trials ADD COLUMN open_id CHARACTER VARYING(36) COLLATE "C.UTF-8";
ALTER TABLE trials ADD CONSTRAINT trials_open_id_unique_idx UNIQUE (open_id);

-- EXPERTDEV-570: Агрегация результатов прокторинга
ALTER TABLE proctoring_responses ADD COLUMN evaluation INTEGER;

-- Вешаем индекс на trial_id в таблице proctoring_responses для ускорения поиска
CREATE INDEX proctoring_responses_trial_id_idx ON proctoring_responses (trial_id);

-- EXPERTDEV-605: Заливать видео в s3
CREATE TABLE proctoring_videos (
    trial_id INTEGER NOT NULL,
    name CHARACTER VARYING(255) COLLATE "C.UTF-8" NOT NULL,
    start_time BIGINT NOT NULL,
    duration INTEGER NOT NULL,
    CONSTRAINT proctoring_videos_trial_id_fkey FOREIGN KEY (trial_id) REFERENCES trials(id) ON UPDATE CASCADE ON DELETE SET NULL
);

ALTER TABLE trials ADD COLUMN session_id CHARACTER VARYING(24) COLLATE "C.UTF-8";
ALTER TABLE trials ADD COLUMN is_video_saved BOOLEAN DEFAULT false NOT NULL;

ALTER TABLE trials ADD CONSTRAINT trials_session_id_unique_idx UNIQUE (session_id);

-- EXPERTDEV-634: Дублируются интервалы в данных для Толоки
ALTER TABLE proctoring_videos
    ADD CONSTRAINT proctoring_videos_trial_id_name_unique UNIQUE (trial_id, name);
