-- EXPERTDEV-722: [API] История изменений

CREATE TYPE draft_status_type AS ENUM ('saved', 'on_moderation', 'published', 'ignored');

CREATE TABLE drafts (
    id SERIAL NOT NULL,
    trial_template_id INTEGER NOT NULL,
    admin_id INTEGER NOT NULL,
    exam JSON NOT NULL,
    save_date TIMESTAMP WITH TIME ZONE NOT NULL,
    status draft_status_type NOT NULL
);
ALTER TABLE ONLY drafts
    ADD CONSTRAINT drafts_id_pkey PRIMARY KEY (id);
ALTER TABLE ONLY drafts
    ADD CONSTRAINT drafts_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates (id) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY drafts
    ADD CONSTRAINT drafts_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins (id) ON UPDATE CASCADE ON DELETE RESTRICT;

-- EXPERTDEV-765: [API] Ручка блокировки на редактирование теста
CREATE TABLE locks (
    id SERIAL NOT NULL,
    trial_template_id INTEGER NOT NULL,
    admin_id INTEGER NOT NULL,
    lock_date TIMESTAMP WITH TIME ZONE NOT NULL,
    unlock_date TIMESTAMP WITH TIME ZONE NOT NULL
);
ALTER TABLE ONLY locks
    ADD CONSTRAINT locks_id_pkey PRIMARY KEY (id);
ALTER TABLE ONLY locks
    ADD CONSTRAINT locks_trial_template_id_fkey FOREIGN KEY (trial_template_id) REFERENCES trial_templates (id) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY locks
    ADD CONSTRAINT locks_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES admins (id) ON UPDATE CASCADE ON DELETE RESTRICT;
