-- admin
ALTER TABLE admins ALTER COLUMN login TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE admins ALTER COLUMN email TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE admins ALTER COLUMN name TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- agencies
ALTER TABLE agencies ALTER COLUMN login TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE agencies ALTER COLUMN title TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE agencies ALTER COLUMN manager TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE agencies ALTER COLUMN manager_email TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE agencies ALTER COLUMN manager_fio TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- answers
ALTER TABLE answers ALTER COLUMN text TYPE TEXT COLLATE "C.UTF-8";

-- auth_types
ALTER TABLE auth_types ALTER COLUMN code TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- certificates
ALTER TABLE certificates ALTER COLUMN firstname TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN lastname TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN middlename TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN postal_index TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN address TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN phone TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN image_path TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE certificates ALTER COLUMN pdf_path TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- questions
ALTER TABLE questions ALTER COLUMN text TYPE TEXT COLLATE "C.UTF-8";

-- roles
ALTER TABLE roles ALTER COLUMN code TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE roles ALTER COLUMN title TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- sections
ALTER TABLE sections ALTER COLUMN code TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE sections ALTER COLUMN title TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- services
ALTER TABLE services ALTER COLUMN code TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE services ALTER COLUMN title TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- trial_templates
ALTER TABLE trial_templates ALTER COLUMN title TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN description TYPE TEXT COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN preview_cert TYPE TEXT COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN rules TYPE TEXT COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN delays TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN validity_period TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN period_before_certificate_reset TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN delay_until_trials_reset TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN slug TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN preview_image_path TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN seo_description TYPE TEXT COLLATE "C.UTF-8";
ALTER TABLE trial_templates ALTER COLUMN og_description TYPE TEXT COLLATE "C.UTF-8";

-- types
ALTER TABLE types ALTER COLUMN code TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE types ALTER COLUMN title TYPE VARCHAR(255) COLLATE "C.UTF-8";

-- users
ALTER TABLE users ALTER COLUMN login TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN email TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN firstname TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN lastname TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN middlename TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN postal_index TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN phone TYPE VARCHAR(255) COLLATE "C.UTF-8";
ALTER TABLE users ALTER COLUMN address TYPE VARCHAR(255) COLLATE "C.UTF-8";

ALTER TABLE admins DISABLE TRIGGER ALL;
ALTER TABLE admins_to_roles DISABLE TRIGGER ALL;
ALTER TABLE agencies DISABLE TRIGGER ALL;
ALTER TABLE answers DISABLE TRIGGER ALL;
ALTER TABLE auth_types DISABLE TRIGGER ALL;
ALTER TABLE categories DISABLE TRIGGER ALL;
ALTER TABLE certificates DISABLE TRIGGER ALL;
ALTER TABLE direct_sync DISABLE TRIGGER ALL;
ALTER TABLE freezing DISABLE TRIGGER ALL;
ALTER TABLE questions DISABLE TRIGGER ALL;
ALTER TABLE roles DISABLE TRIGGER ALL;
ALTER TABLE sections DISABLE TRIGGER ALL;
ALTER TABLE services DISABLE TRIGGER ALL;
ALTER TABLE trial_template_allowed_fails DISABLE TRIGGER ALL;
ALTER TABLE trial_templates DISABLE TRIGGER ALL;
ALTER TABLE trial_templates_to_sections DISABLE TRIGGER ALL;
ALTER TABLE trials DISABLE TRIGGER ALL;
ALTER TABLE trials_to_questions DISABLE TRIGGER ALL;
ALTER TABLE types DISABLE TRIGGER ALL;
ALTER TABLE users DISABLE TRIGGER ALL;

ALTER TABLE admins ENABLE TRIGGER ALL;
ALTER TABLE admins_to_roles ENABLE TRIGGER ALL;
ALTER TABLE agencies ENABLE TRIGGER ALL;
ALTER TABLE answers ENABLE TRIGGER ALL;
ALTER TABLE auth_types ENABLE TRIGGER ALL;
ALTER TABLE categories ENABLE TRIGGER ALL;
ALTER TABLE certificates ENABLE TRIGGER ALL;
ALTER TABLE direct_sync ENABLE TRIGGER ALL;
ALTER TABLE freezing ENABLE TRIGGER ALL;
ALTER TABLE questions ENABLE TRIGGER ALL;
ALTER TABLE roles ENABLE TRIGGER ALL;
ALTER TABLE sections ENABLE TRIGGER ALL;
ALTER TABLE services ENABLE TRIGGER ALL;
ALTER TABLE trial_template_allowed_fails ENABLE TRIGGER ALL;
ALTER TABLE trial_templates ENABLE TRIGGER ALL;
ALTER TABLE trial_templates_to_sections ENABLE TRIGGER ALL;
ALTER TABLE trials ENABLE TRIGGER ALL;
ALTER TABLE trials_to_questions ENABLE TRIGGER ALL;
ALTER TABLE types ENABLE TRIGGER ALL;
ALTER TABLE users ENABLE TRIGGER ALL;

DROP TABLE captcha_status;
DROP TABLE sessions;
DROP TABLE notifications;
DROP TABLE role_mappings;
DROP TABLE trials_to_answers;
DROP TABLE trial_templates_to_categories;
DROP TABLE trial_templates_to_roles;
DROP TABLE worker_schedule;

ALTER TABLE certificates DROP COLUMN initials_path;

ALTER TABLE ONLY questions
    ADD CONSTRAINT questions_category_id_fkey FOREIGN KEY (category_id)
        REFERENCES categories(id) ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE ONLY sections
    ADD CONSTRAINT sections_service_id_fkey FOREIGN KEY (service_id)
        REFERENCES services(id) ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE ONLY trial_templates_to_sections
    ADD CONSTRAINT trial_templates_to_sections_category_id_fkey FOREIGN KEY (category_id)
        REFERENCES categories(id) ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE answers ALTER COLUMN question_version SET NOT NULL;
ALTER TABLE trials_to_questions ALTER COLUMN question_version SET NOT NULL;

ALTER TABLE ONLY answers
    ADD CONSTRAINT answers_questions_fk FOREIGN KEY (question_id, question_version)
        REFERENCES questions (id, version) ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE ONLY trials_to_questions
    ADD CONSTRAINT trials_to_questions_questions_fk FOREIGN KEY (question_id, question_version)
        REFERENCES questions (id, version) ON UPDATE CASCADE ON DELETE SET NULL;

ALTER TABLE certificates ALTER COLUMN trial_id SET NOT NULL;
ALTER TABLE questions ALTER COLUMN section_id SET NOT NULL;
ALTER TABLE trials ALTER COLUMN user_id SET NOT NULL;
ALTER TABLE trials ALTER COLUMN trial_template_id SET NOT NULL;
ALTER TABLE trial_template_allowed_fails ALTER COLUMN trial_template_id SET NOT NULL;
ALTER TABLE trial_template_allowed_fails ALTER COLUMN section_id SET NOT NULL;
ALTER TABLE trial_templates_to_sections ALTER COLUMN trial_template_id SET NOT NULL;
ALTER TABLE trial_templates_to_sections ALTER COLUMN section_id SET NOT NULL;
ALTER TABLE users ALTER COLUMN auth_type_id SET NOT NULL;
ALTER TABLE users ALTER COLUMN role_id SET NOT NULL;
ALTER TABLE trial_templates ALTER COLUMN service_id SET NOT NULL;
ALTER TABLE trial_templates ALTER COLUMN type_id SET NOT NULL;
