CREATE TABLE `auth_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;

INSERT INTO `auth_types` (`id`, `code`)
VALUES (1, 'web');

INSERT INTO `auth_types` (`id`, `code`)
VALUES (2, 'telegram');

ALTER TABLE `users` ADD `auth_type_id` int(11) NOT NULL;
UPDATE `users` SET `auth_type_id` = 1;

ALTER TABLE `users` ADD `yandex_uid` bigint(20) NULL;
UPDATE `users` SET `yandex_uid` = `id`;

ALTER TABLE `users` ADD `uid` bigint(20) NOT NULL;
UPDATE `users` SET `uid` = `id`;

ALTER TABLE `users` ADD UNIQUE KEY `idx_users_uid_auth_type_id` (`uid`,`auth_type_id`);

LOCK TABLES trials WRITE, users WRITE;

ALTER TABLE captcha_status DROP FOREIGN KEY captcha_status_users_fk;
ALTER TABLE sessions DROP FOREIGN KEY sessions_users_fk;
ALTER TABLE trials DROP FOREIGN KEY trials_users_fk;

ALTER TABLE `users` MODIFY `id` bigint(20) AUTO_INCREMENT;

ALTER TABLE `trials` ADD CONSTRAINT `trials_users_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

UNLOCK TABLES;

ALTER TABLE `users`
ADD CONSTRAINT `users_auth_types_fk` FOREIGN KEY (`auth_type_id`) REFERENCES `auth_types` (`id`);

ALTER TABLE `users` MODIFY COLUMN `login` VARCHAR(255) NULL;
