ALTER TABLE trial_templates ADD slug VARCHAR(255) NOT NULL;
UPDATE trial_templates SET slug = '';

ALTER TABLE trial_templates_to_sections DROP COLUMN allowed_fails;

CREATE TABLE `trial_template_allowed_fails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trial_template_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `allowed_fails` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_constr` (`trial_template_id`,`section_id`),
  KEY `section_id` (`section_id`),
  CONSTRAINT `trial_template_allowed_fails_ibfk_1` FOREIGN KEY (`trial_template_id`) REFERENCES `trial_templates` (`id`),
  CONSTRAINT `trial_template_allowed_fails_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`)
) ENGINE=InnoDB;


-- Директ (`trial_template_id`: 1)
--id;code;title;allowed_fails

--156;interface_07_2016;Интерфейс;3
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 156, 3);

--159;keywords_07_2016;"Ключевые слова и операторы";3
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 159, 3);

--162;moderation_07_2016;"Рекламная политика и модерация";1
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 162, 1);

--165;payment_07_2016;"Оплата рекламной кампании";0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 165, 0);

--168;effectivness_07_2016;"Повышение эффективности рекламной кампании";0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 168, 0);

--169;show_rules_07_2016;"Правила показа объявлений";3
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 169, 3);

--171;mobile_ads_07_2016;"Реклама на мобильных устройствах";0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 171, 0);

--174;ad_network_07_2016;Сети;0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 174, 0);

--177;statistic_07_2016;"Статистика и отчеты";1
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 177, 1);

--180;cpc_price_07_2016;"Управление ценой клика";1
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 180, 1);

--183;audience_07_2016;"Условия подбора аудитории";0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 1, 183, 0);

-- Метрика (`trial_template_id`: 4)
--id;code;title;allowed_fails
--138,reports_07_2016,Отчеты,7
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 138, 7);

--141,user_actions_07_2016,"Анализ поведения посетителей",0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 141, 0);

--142,access_and_transfer_07_2016,"Доступы и перенос счетчика",0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 142, 0);

--142,goals_07_2016,Цели,0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 142, 0);

--147,counter_params_07_2016,"Настройки счетчика",2
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 147, 2);

--150,counter_setup_07_2016,"Установка счетчика",0
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 150, 0);

--153,target_call_07_2016,"Целевой звонок",1
INSERT INTO `trial_template_allowed_fails` (`id`, `trial_template_id`, `section_id`, `allowed_fails`)
VALUES (0, 4, 153, 1);
