-- Создаем таблицу связей админов и ролей
CREATE TABLE `admins_to_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_constr` (`admin_id`,`role_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `adminstoroles_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `adminstoroles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB;

-- Добавляем роль "Аналитик"
INSERT INTO `expert`.`roles` (`id`, `code`, `title`, `active`)
VALUES (0, 'analyst', 'Аналитик', 1);

-- Деактивируем все роли, кроме перечисленных
UPDATE `expert`.`roles`
SET `active` = 0
WHERE code NOT IN ('user', 'developer', 'admin', 'analyst')
