'use strict';

const Base = require('models/base');
const { Admin } = require('db/postgres');

const config = require('yandex-config');
const _ = require('lodash');
const Blackbox = require('models/blackbox');

class AdminUser extends Base {
    static *findOrCreate(login, ip, transaction) {
        let storedUser = yield Admin.findOne({ where: { login }, transaction });

        if (!storedUser) {
            const blackboxUser = yield this._getBlackboxUser(login, ip);
            const createResult = yield Admin.findOrCreate({
                where: { uid: blackboxUser.uid },
                defaults: blackboxUser,
                transaction
            });

            [storedUser] = createResult;
        }

        return storedUser.toJSON();
    }

    static *_getBlackboxUser(login, userip) {
        const blackbox = new Blackbox(config.yandexTeamBlackbox);
        const data = yield blackbox.userInfo({ userip, login });

        return {
            uid: parseInt(_.get(data, 'users.0.uid.value'), 10),
            login
        };
    }
}

module.exports = AdminUser;
