'use strict';

const _ = require('lodash');

class Base {
    constructor(data) {
        this._data = data;
    }

    get fields() {
        return [];
    }

    toJSON() {
        return _.pick(this._data, this.fields);
    }

    get id() {
        return this._data.id;
    }

    get(name) {
        return _.get(this._data, name);
    }

    set(name, value) {
        this._data.set(name, value);
    }

    *save(options) {
        yield this._data.save(options);
    }
}

module.exports = Base;
