const { Draft } = require('db/postgres');

class DraftModel {
    static *create(data, transaction) {
        const { trialTemplateId, adminId, exam, status } = data;

        return yield Draft.create({
            trialTemplateId,
            adminId,
            exam,
            saveDate: new Date(),
            status: status || 'saved'
        }, { transaction });
    }

    static *find(trialTemplateId, transaction) {
        return yield Draft.findOne({
            where: { trialTemplateId },
            attributes: ['exam', 'status'],
            order: [['saveDate', 'DESC']],
            raw: true,
            transaction
        });
    }

    static *updateStatus(draftId, status, transaction) {
        yield Draft.update({ status }, {
            where: { id: draftId },
            fields: ['status'],
            transaction
        });
    }
}

module.exports = DraftModel;
