module.exports = {
    qr: {
        url: (certId, lastname) => [
            `https://yandex.ru/adv/expert/certificates?certId=${certId}&lastname=${lastname}`
        ]
    },
    direct: {
        annotation: name => [
            `Сертификат подтверждает, что ${name}`,
            'обладает необходимым уровнем знаний для профессионального',
            'ведения рекламных кампаний в Яндекс Директе.'
        ],
        certNumber: number => [
            'СЕРТИФИКАТ',
            `# ${number}`
        ]
    },
    metrika: {
        annotation: name => [
            `Сертификат подтверждает, что ${name}`,
            'обладает необходимым уровнем знаний для профессиональной',
            'работы с системой веб-аналитики Яндекс Метрика.'
        ],
        certNumber: number => [
            'СЕРТИФИКАТ',
            `# ${number}`
        ]
    },
    levelCert: {
        'direct_base': {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) базовый',
                'тест на знание инструментов',
                'Яндекс Директа'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => [
                'БАЗОВЫЙ УРОВЕНЬ'
            ],
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по Яндекс Директу'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        },
        'direct_pro': {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) продвинутый',
                'тест на знание инструментов',
                'Яндекс Директа'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => [
                'ПРОДВИНУТЫЙ УРОВЕНЬ'
            ],
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по Яндекс Директу'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        },
        metrika: {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) тест на знание',
                'инструментов Яндекс Метрики'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => false,
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по Яндекс Метрике'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        },
        cpm: {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) тест на знание',
                'инструментов по работе',
                'с медийной рекламой'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => false,
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по медийной рекламе'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        },
        zen: {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) тест на знание',
                'инструментов Яндекс Дзена'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => false,
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по Яндекс Дзену'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        },
        rsya: {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) тест на знание',
                'инструментов по работе',
                'с РСЯ для площадок'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => false,
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по РСЯ для площадок'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        },
        market: {
            certNumber: number => [
                `№ ${number}`
            ],
            description: () => [
                'успешно прошел(-ла) тест на знание',
                'инструментов',
                'Яндекс Маркета'
            ],
            due: () => [
                `до`
            ],
            dueDate: date => [
                `${date}`
            ],
            level: () => false,
            nameCert: () => [
                'Сертификат',
                'специалиста',
                'по Яндекс Маркету'
            ],
            check: () => [
                'Проверка подлинности',
                'сертификата'
            ]
        }
    }
};
