const fs = require('fs');

const baseFontCss = {
    certNumber: {
        size: '14',
        color: '#000000',
        bold: 'bold',
        fontFamily: 'Yandex Sans Display',
        lineHeight: 0,
        letterSpacing: 2,
        left: 477,
        top: 55
    },
    due: {
        size: '10',
        color: '#000000',
        bold: '',
        fontFamily: 'Yandex Sans Display',
        lineHeight: 0,
        letterSpacing: 0,
        left: 477,
        top: 75
    },
    dueDate: {
        size: '10',
        color: '#000000',
        bold: '',
        fontFamily: 'Yandex Sans Display',
        lineHeight: 0,
        letterSpacing: 0,
        left: 500,
        top: 75
    },
    name: {
        size: '26',
        color: '#000000',
        bold: 'bold',
        fontFamily: 'Yandex Sans Display',
        lineHeight: 0,
        letterSpacing: 0,
        left: 40,
        top: 160
    },
    description: {
        size: '14',
        color: '#000000',
        bold: '',
        fontFamily: 'Yandex Sans Text',
        lineHeight: 16,
        letterSpacing: 0,
        left: 40,
        top: 195
    },
    level: {
        pdf: {
            size: '48',
            color: '#FC3F1D',
            bold: 'bold',
            fontFamily: 'Yandex Sans Text',
            lineHeight: 0,
            letterSpacing: 4,
            left: 225,
            top: 2304
        },
        png: {
            size: '24',
            color: '#FC3F1D',
            bold: 'bold',
            fontFamily: 'Yandex Sans Text',
            lineHeight: 0,
            letterSpacing: 2,
            left: 105,
            top: 1152
        }
    },
    nameCert: {
        size: '45',
        color: '#FFFFFF',
        bold: 'bold',
        fontFamily: 'Yandex Sans Display',
        lineHeight: 50,
        letterSpacing: -1,
        left: 40,
        top: 430
    },
    check: {
        size: '8',
        color: '#FFFFFF',
        bold: '',
        fontFamily: 'Yandex Sans Text',
        lineHeight: 9,
        letterSpacing: 0,
        left: 40,
        top: 672
    },
    qrCode: {
        left: 40,
        top: 701
    }
};
const directBasicFontCss = JSON.parse(JSON.stringify(baseFontCss));

directBasicFontCss.level.color = '#FC3F1D';

const marketBasicFontCss = JSON.parse(JSON.stringify(baseFontCss));

marketBasicFontCss.level.color = '#FC3F1D';

const directProFontCss = JSON.parse(JSON.stringify(baseFontCss));

directProFontCss.level.color = '#1A4A7F';

const mediaAdvFontCss = JSON.parse(JSON.stringify(baseFontCss));

mediaAdvFontCss.nameCert.size = '40';
mediaAdvFontCss.nameCert.lineHeight = 45;
const pcrFontCss = JSON.parse(JSON.stringify(mediaAdvFontCss));

module.exports = {
    sizes: {
        initials: {
            png: {
                width: 1200,
                height: 630,
                padding: 60,
                borderTop: 0,
                borderLeft: 0,
                scale: 1
            },
            pdf: {
                width: 3338, // 3508 - borderLeft * 2
                height: 1770, // 2480 - borderLeft * 2 - borderTop * 2
                padding: 174,
                borderTop: 295,
                borderLeft: 60,
                scale: 2.78
            }
        },
        old: {
            png: {
                width: 300,
                height: 424,
                padding: 30,
                borderTop: 125,
                borderLeft: 0,
                scale: 1
            },
            pdf: {
                width: 2480,
                height: 3508,
                padding: 248,
                borderTop: 1034,
                borderLeft: 0,
                scale: 8.27
            }
        },
        levelCert: {
            png: {
                width: 1190,
                height: 1684,
                padding: 40,
                borderTop: 0,
                borderLeft: 0,
                scale: 2,
                widthQR: 100
            },
            pdf: {
                width: 2380,
                height: 3368,
                padding: 40,
                borderTop: 0,
                borderLeft: 0,
                scale: 4,
                widthQR: 100
            }
        },
        qRcodeController: {
            png: {
                width: 200
            },
            pdf: {
                width: 400
            }
        },
        yaLetter: {
            png: {
                width: 1200,
                height: 630,
                lineHeight: {
                    status: 60,
                    name: 92
                }
            },
            pdf: {
                width: 2480,
                height: 3508,
                borderLeft: 216,
                lineHeight: {
                    status: 125,
                    name: 300,
                    text: 58
                }
            }
        }
    },

    letters: {
        firstWithGlyph: {
            eur: ['Й', 'Ё'],
            cjk: []
        },
        lastWithGlyph: {
            eur: ['Щ', 'Д', 'Ц', 'Q'],
            cjk: []
        },
        wide: {
            eur: ['Ж', 'Щ', 'Ш', 'Ы', 'Ю'],
            cjk: []
        },
        tight: {
            eur: ['I'],
            cjk: []
        },
        big: {
            eur: ['Р', 'Г'],
            cjk: []
        }
    },

    fonts: {
        initials: {
            eur: 'Yandex Sans Display',
            cjk: 'Droid Sans Fallback'
        },
        text: {
            ru: 'Yandex Sans Text',
            en: 'Yandex Sans Text',
            cn: 'Droid Sans Fallback'
        }
    },

    fontsCss: {
        levelCert: {
            'direct_base': directBasicFontCss,
            'direct_pro': directProFontCss,
            metrika: baseFontCss,
            cpm: mediaAdvFontCss,
            zen: baseFontCss,
            rsya: pcrFontCss,
            market: marketBasicFontCss
        }
    },

    initialsRatio: {
        eur: 0.5,
        cjk: 0.4
    },

    regex: {
        cjkSymbol: '[\u4e00-\u9fff]',
        cjkSymbols: '[\u4e00-\u9fff]{1,2}',
        notCjkSymbol: '[^\u4e00-\u9fff]'
    },

    services: {
        initials: {
            direct: {
                logo: {
                    png: fs.readFileSync('images/logo/direct_ru.png'),
                    pdf: fs.readFileSync('images/logo/direct_ru@3x.png')
                },
                background: {
                    png: fs.readFileSync('images/background/metrika_ru.png'),
                    pdf: fs.readFileSync('images/background/metrika_ru@3x.png')
                }
            },
            metrika: {
                logo: {
                    png: fs.readFileSync('images/logo/direct_en.png'),
                    pdf: fs.readFileSync('images/logo/direct_en@3x.png')
                },
                background: {
                    png: fs.readFileSync('images/background/metrika_ru.png'),
                    pdf: fs.readFileSync('images/background/metrika_ru@3x.png')
                }
            },
            'direct_en': {
                logo: {
                    png: fs.readFileSync('images/logo/direct_en.png'),
                    pdf: fs.readFileSync('images/logo/direct_en@3x.png')
                },
                background: {
                    png: fs.readFileSync('images/background/direct_en.png'),
                    pdf: fs.readFileSync('images/background/direct_en@3x.png')
                }
            },
            'direct_cn': {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_en.png'),
                    pdf: fs.readFileSync('images/logo/yandex_en@3x.png')
                },
                background: {
                    png: fs.readFileSync('images/background/direct_cn.png'),
                    pdf: fs.readFileSync('images/background/direct_cn@3x.png')
                }
            },
            'metrika_en': {
                logo: {
                    png: fs.readFileSync('images/logo/metrika_en.png'),
                    pdf: fs.readFileSync('images/logo/metrika_en@3x.png')
                },
                background: {
                    png: fs.readFileSync('images/background/metrika_en.png'),
                    pdf: fs.readFileSync('images/background/metrika_en@3x.png')
                }
            }
        },
        old: {
            direct: {
                background: {
                    png: fs.readFileSync('images/background/direct_old.jpg'),
                    pdf: fs.readFileSync('images/background/direct_old@8x.jpg')
                }
            },
            metrika: {
                background: {
                    png: fs.readFileSync('images/background/metrika_old.jpg'),
                    pdf: fs.readFileSync('images/background/metrika_old@8x.jpg')
                }
            }
        },
        yaLetter: {
            ru: {
                background: {
                    png: fs.readFileSync('images/background/ya_ru.png'),
                    pdf: fs.readFileSync('images/background/ya_ru@4x.png')
                },
                logo: {
                    pdf: fs.readFileSync('images/logo/yandex_ru@3x.png')
                },
                proctoringLabel: {
                    png: fs.readFileSync('images/proctoringLabel/ya_ru_pro_png.png'),
                    pdf: fs.readFileSync('images/proctoringLabel/ya_ru_pro_pdf.png')
                }
            },
            en: {
                background: {
                    png: fs.readFileSync('images/background/ya_en.png'),
                    pdf: fs.readFileSync('images/background/ya_en@4x.png')
                },
                logo: {
                    pdf: fs.readFileSync('images/logo/yandex_en@3x.png')
                }
            },
            cn: {
                background: {
                    png: fs.readFileSync('images/background/ya_en.png'),
                    pdf: fs.readFileSync('images/background/ya_en@4x.png')
                },
                logo: {
                    pdf: fs.readFileSync('images/logo/yandex_en@3x.png')
                }
            }
        },
        levelCert: {
            'direct_base': {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_basic@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_basic@4x.jpg')
                }
            },
            'direct_pro': {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_hard@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_hard@4x.jpg')
                }
            },
            metrika: {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_not@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_not@4x.jpg')
                }
            },
            cpm: {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_not@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_not@4x.jpg')
                }
            },
            zen: {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_not@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_not@4x.jpg')
                }
            },
            rsya: {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_not@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_not@4x.jpg')
                }
            },
            market: {
                logo: {
                    png: fs.readFileSync('images/logo/yandex_log.png'),
                    pdf: fs.readFileSync('images/logo/yandex_log.png')
                },
                background: {
                    png: fs.readFileSync('images/background/level_not@2x.jpg'),
                    pdf: fs.readFileSync('images/background/level_not@4x.jpg')
                }
            }
        }
    },

    tankerKeys: {
        direct: 'direct',
        'direct_en': 'direct',
        'direct_cn': 'direct',
        'direct_pro': 'direct',
        'metrika': 'metrika',
        'metrika_en': 'metrika',
        market: 'market',
        rsya: 'rsya',
        publisher: 'publisher',
        cpm: 'cpm',
        zen: 'zen'
    }
};
