const QRCode = require('qrcode');
const OPTIONS = require('yandex-config').draw;
const TEXT = require('models/draw/data/old-eur.text.js');

class QRcodeController {
    static _getType() {
        return 'qRcodeController';
    }

    static _getUrl(certId, lastname) {
        return TEXT.qr.url(certId, lastname);
    }

    static _getWidth(format) {
        return OPTIONS.sizes[this._getType()][format].width;
    }

    static *createQRcodeUrl(certId, lastname, format) {
        const width = QRcodeController._getWidth(format);
        const url = QRcodeController._getUrl(certId, lastname);

        return yield QRCode.toDataURL(url, {
            width,
            color: {
                dark: '#000',
                light: '#0000'
            }
        });
    }
}

module.exports = QRcodeController;
