'use strict';

const _ = require('lodash');
const { achievements } = require('yandex-config');

class Achievement {
    constructor(data) {
        this._data = data;
    }

    get isSuitable() {
        return this._data.type === 'achievement';
    }

    drawCert() {
        return {
            url: _.get(achievements, this._data.service, '')
        };
    }
}

module.exports = Achievement;
