'use strict';

const moment = require('moment');
const { Image } = require('canvas');

const YaLetterBase = require('models/draw/ya-letter-base');

class YaLetterPdf extends YaLetterBase {
    get format() {
        return 'pdf';
    }

    /**
     * Заменяет параметры имени и фамилии в тексте
     * @param {String} text - Текст, в котором производится замена
     * @returns {String}
     * @private
     */
    _replaceName(text) {
        return text
            .replace('<i18n:param>firstname</i18n:param>', this._data.firstname)
            .replace('<i18n:param>lastname</i18n:param>', this._data.lastname);
    }

    _drawText(options) {
        const lineHeight = this._getSize('lineHeight').text;
        const marginLeft = this._getSize('borderLeft');
        let { marginTop } = options;

        this._ctx.fillStyle = '#000';
        this._ctx.font = this._textFont(options.fontSize);

        options.text
            .split('\n')
            .map(phrase => {
                this._ctx.fillText(phrase, marginLeft, marginTop);
                marginTop += lineHeight;
            });
    }

    _drawVerificationText(options) {
        if (this.language === 'cn') {
            options.marginTop += this._getSize('lineHeight').text;
        }

        this._drawText(options);
    }

    _drawAdditionalInfo() {
        this._drawText({
            text: `${this._i18n('id')}${this._data.certId}`,
            fontSize: 50,
            marginTop: 2946
        });

        this._drawText({
            text: `${this._i18n('due')} ${moment(this._data.dueDate).format('DD.MM.YYYY')}`,
            fontSize: 50,
            marginTop: 3067
        });

        this._drawVerificationText({
            text: this._i18n('verification'),
            fontSize: 50,
            marginTop: 3184
        });
    }

    _drawLogo() {
        const dy = this.language === 'ru' ? 3115 : 3095;
        const img = new Image();

        img.src = this.logo;
        this._ctx.drawImage(img, 1713, dy, 546, 209); // image, dx, dy, dw, dh
    }

    /**
     * Входная точка для рисования сертификата
     * @returns {Buffer}
     */
    drawCert() {
        const canvas = this._createCanvas();

        this._drawBackground();
        this._drawStatus({
            fontSize: 100,
            marginLeft: 216,
            marginTop: 2287
        });

        const positionAfterName = this._drawName({
            fontSize: 250,
            text: this._getFormattedName(),
            width: 2038,
            maxSizeForText: 2038,
            marginLeft: 216,
            marginTop: 462,
            lineHeight: this._getSize('lineHeight').name
        });

        this._drawText({
            text: this._replaceName(this._i18n(`annotation.${this.service}`)),
            fontSize: 50,
            marginTop: positionAfterName - 80
        });

        this._drawAdditionalInfo();
        this._drawLogo();

        this._drawProctoringMark({
            marginLeft: 216,
            marginTop: 1920
        });

        return {
            buffer: canvas.toBuffer()
        };
    }
}

module.exports = YaLetterPdf;
