'use strict';

const YaLetterBase = require('models/draw/ya-letter-base');

class YaLetterPng extends YaLetterBase {
    get format() {
        return 'png';
    }

    /**
     * Входная точка для рисования сертификата
     * @returns {Buffer}
     */
    drawCert() {
        const canvas = this._createCanvas();

        this._drawBackground();
        this._drawStatus({
            fontSize: 50,
            marginLeft: 644,
            marginTop: 576
        });
        this._drawName({
            fontSize: 76,
            text: this._getFormattedName(),
            width: 512,
            maxSizeForText: 512,
            marginLeft: 644,
            marginTop: 120,
            lineHeight: this._getSize('lineHeight').name
        });
        this._drawProctoringMark({
            marginLeft: 646,
            marginTop: 408
        });

        return {
            buffer: canvas.toBuffer()
        };
    }
}

module.exports = YaLetterPng;
