'use strict';

const _ = require('lodash');
const { ProctoringVideos } = require('db/postgres');

const BaseModel = require('models/base');

class ProctoringVideosModel extends BaseModel {
    static *create(trialId, proctoringVideos, transaction) {
        const attributes = ['name', 'startTime', 'duration', 'source'];
        const dataForCreate = proctoringVideos.map(videoData => _.assign(
            { trialId },
            _.pick(videoData, attributes)
        ));

        yield ProctoringVideos.bulkCreate(dataForCreate, { transaction });
    }

    static *getVideosByTrial(trialIds, sources, transaction) {
        const videos = yield ProctoringVideos.findAll({
            where: {
                trialId: { $in: trialIds },
                source: { $in: sources }
            },
            attributes: ['trialId', 'name', 'startTime', 'duration'],
            transaction,
            order: [['startTime']],
            raw: true
        });

        return _.groupBy(videos, 'trialId');
    }

    static *getVideosNames(trialId, sources) {
        const videos = yield ProctoringVideos.findAll({
            where: {
                trialId,
                source: { $in: sources }
            },
            attributes: ['name'],
            order: [['startTime']],
            raw: true
        });

        return _.map(videos, 'name');
    }
}

module.exports = ProctoringVideosModel;
