const moment = require('moment');
const _ = require('lodash');

const BaseReport = require('models/report/items/baseReport');

class StatBaseReport extends BaseReport {
    static _getAllPeriods(from, to) {
        from = moment(from);
        to = moment(to);

        const periods = [];

        while (to >= from) {
            periods.push(from.format('MMMM YYYY'));
            from.add(1, 'month');
        }

        return periods;
    }

    static _prepareSummaryReport(reportData, options) {
        const { from, to } = options;
        const periods = this._getAllPeriods(from, to);

        const hash = _.groupBy(reportData, 'period');

        periods.forEach(period => {
            if (!_.has(hash, period)) {
                const periodDate = this._getFirstDayOfMonth(period);

                hash[period] = [_.assign({ period, periodDate }, this.emptyReport)];
            }
        });

        return _(hash)
            .values()
            .flatten()
            .orderBy(({ period }) => moment(period, 'MMMM YYYY'), 'asc')
            .value();
    }

    static _getLocalizedPeriod(period) {
        return _.capitalize(
            moment(period, 'MMMM YYYY')
                .locale('ru')
                .format('MMMM YYYY')
        );
    }

    static _getFirstDayOfMonth(period) {
        return moment(period, 'MMMM YYYY')
            .locale('ru')
            .format('YYYY-MM-01');
    }
}

module.exports = StatBaseReport;
