const { tracker } = require('yandex-config');

const trackerClient = require('@yandex-int/st-client').init(tracker.options);

const log = require('logger');
const Notifier = require('models/notifier');

class Tracker {
    static *createPendingTicket(trialId) {
        const data = {
            queue: tracker.queue,
            summary: `Нет видео для pending-попытки №${trialId}`,
            followers: tracker.followers,
            description: 'Необходимо провести апелляцию вручную'
        };

        try {
            yield trackerClient.createIssue(data);
        } catch (err) {
            log.error('Ticket was not created', err);

            yield Notifier.failedCreateTicket({
                queue: tracker.queue,
                html: `<p>Не удалось создать тикет для pending-попытки без видео №${trialId}</p>`
            });
        }
    }
}

module.exports = Tracker;
