'use strict';

const _ = require('lodash');

const BaseUserModel = require('models/user/baseUserModel');

class TelegramUser extends BaseUserModel {
    static _getUserData(telegramUser, storedUser) {
        return [
            { fieldName: 'login', telegramName: 'username' },
            { fieldName: 'firstname', telegramName: 'firstname' },
            { fieldName: 'lastname', telegramName: 'lastname' }
        ].reduce((result, item) => {
            const storedData = _.get(storedUser, item.fieldName);

            result[item.fieldName] = _.get(telegramUser, item.telegramName, storedData);

            return result;
        }, {});
    }

    static _setUserData() {
        return;
    }

    static get authType() {
        return 'telegram';
    }
}

module.exports = TelegramUser;
