const got = require('got');
const co = require('co');

const WebUser = require('models/user/webUser');
const DirectModel = require('models/direct');

const { Agency } = require('db/postgres');

const AGENCIES = [
    { clientId: 2121089, login: 'sistemim' },
    { clientId: 3907348, login: 'aprestigeajans' },
    { clientId: 3934517, login: 'teknokrasi' },
    { clientId: 4861258, login: 'semsemsem-sem' },
    { clientId: 4913749, login: 'adxclusive' },
    { clientId: 5339533, login: 'planb-reklam' },
    { clientId: 5564613, login: 'hype-agency' },
    { clientId: 5708771, login: 'crm-medya' },
    { clientId: 5711453, login: 'destex-reklam' },
    { clientId: 5877878, login: 'corneadigital' },
    { clientId: 5878070, login: 'adresgezginitr' },
    { clientId: 5883519, login: 'profajtr' },
    { clientId: 5885953, login: 'roipublic' },
    { clientId: 5981391, login: 'sempeaktr' },
    { clientId: 5981685, login: 'aura-bulent' },
    { clientId: 5991077, login: 'deepdijital' },
    { clientId: 6154477, login: 'vizyonmedyatr' },
    { clientId: 6378863, login: 'reklamfoni-tr' },
    { clientId: 6381628, login: 'alora-tr' },
    { clientId: 6381751, login: 'mobitek-tr' },
    { clientId: 6407656, login: 'vivakiturkey' },
    { clientId: 6407812, login: 'omd-turkiye' },
    { clientId: 6407995, login: 'dijital-buro' },
    { clientId: 6408208, login: 'digitouch' },
    { clientId: 6450802, login: 'mindshare-tr' },
    { clientId: 6451004, login: 'mediacom-tr' },
    { clientId: 6451060, login: 'mec-tr' },
    { clientId: 6451106, login: 'maxus-tr' },
    { clientId: 6819150, login: 'zer-kocmedya' },
    { clientId: 7062185, login: 'sistemim-2015' },
    { clientId: 7076479, login: 'bigmedya2' },
    { clientId: 7276264, login: 'yndx-uncdigital' },
    { clientId: 7335779, login: 'denemeajans1' },
    { clientId: 7396223, login: 'semtr2015' },
    { clientId: 7472379, login: 'yndx-interhol' },
    { clientId: 7801563, login: 'yndx-iprospect' },
    { clientId: 7822759, login: 'dpistanbul' },
    { clientId: 7826523, login: 'yndx-boosmart' },
    { clientId: 7889422, login: 'armapanel' },
    { clientId: 7950983, login: 'yndx-tekkilavuz' },
    { clientId: 7956664, login: 'dijitaltik' },
    { clientId: 7980807, login: 'sanalsirket' },
    { clientId: 10080701, login: 'yndx-inveon' },
    { clientId: 13054342, login: 'kubix-digital' },
    { clientId: 13087320, login: 'kariasoft' },
    { clientId: 13638971, login: 'adquality-agency' },
    { clientId: 19877284, login: 'laysosreklam' },
    { clientId: 22736056, login: 'gevreklam' },
    { clientId: 30567558, login: 'crea-ist' },
    { clientId: 30853149, login: 'us-yazilim' }
];

// Удаляем упоминание ручки по просьбе Директа https://st.yandex-team.ru/DIRECT-94006
const DIRECT_PROD_URL = 'deprecated_url';

function getClientIDs() {
    return AGENCIES.map(agency => agency.clientId);
}

function *getUIDs(clientIDs) {
    const options = {
        query: { 'client_ids': clientIDs.join(','), json: 1 }
    };
    const agenciesInfo = yield got(DIRECT_PROD_URL, options);

    return JSON.parse(agenciesInfo.body);
}

function *getAgencyId(data) {
    const agencyInstance = yield Agency.findOrCreate({
        attributes: ['id'],
        where: { login: data.agency.login },
        defaults: data.agency
    });
    const [, isCreated] = agencyInstance;

    if (!isCreated) {
        yield Agency.update(data.agency, {
            fields: ['manager'],
            where: { login: data.agency.login }
        });
    }

    return agencyInstance[0].get('id');
}

// eslint-disable-next-line complexity
function *update(data, clientIDs) {
    for (let i = 0; i < clientIDs.length; i += 1) {
        const uids = data[clientIDs[i]];

        if (!uids || !uids[0]) {
            continue;
        }

        const [userUid] = uids;

        const agencyInfo = yield DirectModel.getAgencyInfo(userUid);
        const agencyId = yield getAgencyId(agencyInfo);

        for (const uid of uids) {
            const user = yield WebUser.findUser({ where: { uid } });

            // eslint-disable-next-line max-depth
            if (user) {
                user.set('agencyId', agencyId);
                yield user.save();
            }
        }
    }
}

co(function *() {
    const clientIDs = getClientIDs();
    const uids = yield getUIDs(clientIDs);

    yield update(uids, clientIDs);
});
