const _ = require('lodash');
const co = require('co');
const config = require('yandex-config');
const moment = require('moment');

const {
    Certificate,
    Trial,
    User
} = require('db/postgres');

const Blackbox = require('models/blackbox');
const blackbox = new Blackbox(config.blackbox);

const EXAM_ID = 40;
const VALIDITY_PERIOD = 12; // число месяцев действия сертификата

const USERS = [
    {
        lastname: '王',
        firstname: '旭芳',
        confirmedDate: new Date(2016, 9, 4, 20, 0, 0),
        login: 'fangfangstar520'
    },
    {
        lastname: '吴',
        firstname: '天丽',
        confirmedDate: new Date(2016, 8, 7, 20, 0, 0),
        login: 'aijingads'
    },
    {
        lastname: '孟',
        firstname: '雪',
        confirmedDate: new Date(2016, 8, 7, 20, 0, 0),
        login: 'nanjingmeishuo'
    },
    {
        lastname: '叶',
        firstname: '于路',
        confirmedDate: new Date(2016, 8, 7, 20, 0, 0),
        login: 'liu-juan2016'
    },
    {
        lastname: '宋',
        firstname: '东屹',
        confirmedDate: new Date(2016, 8, 7, 20, 0, 0),
        login: 'raymond-song'
    },
    {
        lastname: '赵',
        firstname: '豪',
        confirmedDate: new Date(2016, 8, 7, 20, 0, 0),
        login: 'xsy-mark'
    },
    {
        lastname: '仝',
        firstname: '瑶',
        confirmedDate: new Date(2016, 2, 31, 20, 0, 0),
        login: 'tonia-tong'
    },
    {
        lastname: '黄',
        firstname: '晓洁',
        confirmedDate: new Date(2016, 2, 31, 20, 0, 0),
        login: 'youzu'
    },
    {
        lastname: '胡',
        firstname: '磊',
        confirmedDate: new Date(2016, 2, 31, 20, 0, 0),
        login: 'singoo01'
    },
    {
        lastname: '申',
        firstname: '鼎博',
        confirmedDate: new Date(2016, 5, 24, 20, 0, 0),
        login: 'xsy-dingboshen'
    },
    {
        lastname: '尤',
        firstname: '玉辉',
        confirmedDate: new Date(2016, 5, 24, 20, 0, 0),
        login: 'grace8888'
    },
    {
        lastname: '邱',
        firstname: '聪玮',
        confirmedDate: new Date(2016, 7, 18, 20, 0, 0),
        login: 'qiucongwei01'
    },
    {
        login: 'payease',
        firstname: 'Maria',
        lastname: 'Brusilova',
        confirmedDate: new Date(2016, 8, 14, 20, 0, 0)
    }
];

function *updateUsers() {
    for (let i = 0; i < USERS.length; i += 1) {
        const blackboxData = yield blackbox.userInfo({
            login: USERS[i].login,
            userip: '12.12.12.12'
        });

        USERS[i].uid = _.get(blackboxData, 'body.users.0.id');
    }
}

function *createCertificates() {
    const result = [];

    for (const user of USERS) {
        if (!user.uid) {
            console.error('User not exists');

            continue;
        }

        const dbUser = yield User.findOrCreate({
            where: { yandexUid: user.uid },
            defaults: _.assign(
                _.pick(user, ['login', 'firstname', 'lastname']),
                { roleId: 1, yandexUid: user.uid, uid: user.uid, authTypeId: 1 }
            )
        });
        const userData = dbUser[0].toJSON();

        const finished = moment(user.confirmedDate).toDate();
        const trialData = yield Trial.findOrCreate({
            where: { userId: userData.id, trialTemplateId: EXAM_ID, finished },
            defaults: {
                userId: userData.id,
                trialTemplateId: EXAM_ID,
                started: moment(user.confirmedDate).subtract(1, 'hour').toDate(),
                finished,
                passed: 1,
                questionCount: 47,
                allowedFails: 7,
                timeLimit: 2820000,
                sequenceNumber: 1,
                expired: 1,
                nullified: 0
            }
        });

        const trialId = trialData[0].get('id');
        const certData = yield Certificate.findOrCreate({
            where: { trialId },
            defaults: {
                firstname: user.firstname,
                lastname: user.lastname,
                dueDate: moment(user.confirmedDate).add(VALIDITY_PERIOD, 'month').toDate(),
                trialId,
                active: 1,
                confirmedDate: finished
            }
        });

        const host = 'https://yandex.com/adv/expert/certificates';

        result.push(`${host}?certId=${certData[0].get('id')}&lastname=${certData[0].get('lastname')}`);
    }

    result.forEach(url => console.log(url));
}

co(function *() {
    yield updateUsers();
    yield createCertificates();
});
