const _ = require('lodash');
const co = require('co');
const moment = require('moment');

const {
    Certificate,
    Trial,
    TrialTemplate,
    User
} = require('db/postgres');

const EXAM_IDS = [44, 4];
const VALIDITY_PERIOD = 1200; // число месяцев действия сертификата
const USER = {
    firstname: 'Vasily',
    lastname: 'Pupkin',
    confirmedDate: new Date(2019, 9, 18, 15, 0, 0),
    login: 'at-direct-freelancer',
    uid: 965989399
};
const HOST = 'https://l7test.yandex.ru/adv/expert/certificates';

function *getExamsData() {
    const exams = yield TrialTemplate.findAll({
        where: { id: EXAM_IDS },
        attributes: ['id', 'typeId', 'isProctoring'],
        raw: true
    });

    return _.groupBy(exams, 'id');
}

function *createCertificates(examsData) {
    const result = [];

    const dbUser = yield User.findOrCreate({
        where: { yandexUid: USER.uid },
        defaults: _.assign(
            _.pick(USER, ['login', 'firstname', 'lastname']),
            { roleId: 1, yandexUid: USER.uid, uid: USER.uid, authTypeId: 1 }
        )
    });

    const userData = dbUser[0].toJSON();

    for (const trialTemplateId of EXAM_IDS) {
        const finished = moment(USER.confirmedDate).toDate();
        const defaultTrialData = {
            userId: userData.id,
            trialTemplateId,
            started: moment(USER.confirmedDate).subtract(1, 'hour').toDate(),
            finished,
            passed: 1,
            questionCount: 60,
            allowedFails: 7,
            timeLimit: 3600000,
            sequenceNumber: 1,
            expired: 1,
            nullified: 0
        };
        const [{ id: examId, isProctoring, typeId }] = examsData[trialTemplateId];

        if (isProctoring) {
            defaultTrialData.filesStatus = 'saved';
            defaultTrialData.openId = `test-open-id-${examId}`;
        }

        const trialData = yield Trial.findOrCreate({
            where: { userId: userData.id, trialTemplateId, finished },
            defaults: defaultTrialData
        });

        const trialId = trialData[0].get('id');
        const certData = yield Certificate.findOrCreate({
            where: { trialId },
            defaults: {
                firstname: USER.firstname,
                lastname: USER.lastname,
                dueDate: moment(USER.confirmedDate).add(VALIDITY_PERIOD, 'month').toDate(),
                trialId,
                active: 1,
                confirmedDate: finished,
                confirmed: 1,
                typeId
            }
        });

        result.push(`${HOST}?certId=${certData[0].get('id')}&lastname=${certData[0].get('lastname')}`);
    }

    result.forEach(url => console.log(url));
}

co(function *() {
    const exams = yield getExamsData();

    yield createCertificates(exams);
});
