const { Certificate, Trial } = require('db/postgres');

const moment = require('moment');
const co = require('co');

const EXAM_IDS = [1, 4, 37, 38, 39, 40, 41, 42, 43];
const USER_INFO = {
    id: 324617449,
    login: 'bloguser-07',
    firstname: 'Блогов',
    lastname: 'Пользователь'
};

const EXAMS_INFO = {
    1: {
        lang: 'ru',
        questionCount: 60,
        allowedFails: 17,
        timeLimit: 3600000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2015, 5, 15), new Date(2016, 9, 15), new Date(2017, 9, 13)]
    },
    4: {
        lang: 'ru',
        questionCount: 36,
        allowedFails: 7,
        timeLimit: 2160000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2015, 5, 15), new Date(2016, 9, 15), new Date(2017, 9, 13)]
    },
    37: {
        lang: 'ru',
        questionCount: 11,
        allowedFails: 2,
        timeLimit: 660000,
        validityPeriod: 1200, // число месяцев действия сертификата
        dates: [new Date(2016, 9, 15), new Date(2017, 9, 13)]
    },
    38: {
        lang: 'com',
        questionCount: 47,
        allowedFails: 7,
        timeLimit: 3300000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2016, 9, 15), new Date(2017, 9, 13)]
    },
    39: {
        lang: 'com',
        questionCount: 33,
        allowedFails: 7,
        timeLimit: 1980000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2016, 9, 15), new Date(2017, 9, 13)]
    },
    40: {
        lang: 'com',
        questionCount: 60,
        allowedFails: 14,
        timeLimit: 3600000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2016, 9, 15), new Date(2017, 9, 13)]
    },
    41: {
        lang: 'ru',
        questionCount: 50,
        allowedFails: 17,
        timeLimit: 3600000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2017, 9, 13)]
    },
    42: {
        lang: 'ru',
        questionCount: 38,
        allowedFails: 8,
        timeLimit: 3600000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2017, 9, 13)]
    },
    43: {
        lang: 'ru',
        questionCount: 134,
        allowedFails: 10,
        timeLimit: 3600000,
        validityPeriod: 12, // число месяцев действия сертификата
        dates: [new Date(2017, 9, 13)]
    }
};

const createCertificates = function *() {
    const result = [];

    for (let i = 0; i < EXAM_IDS.length; i += 1) {
        const examId = EXAM_IDS[i];

        for (let j = 0; j < EXAMS_INFO[examId].dates.length; j += 1) {
            const date = EXAMS_INFO[examId].dates[j];

            const trialData = yield Trial.findOrCreate({
                where: { userId: USER_INFO.id, trialTemplateId: examId, finished: date },
                defaults: {
                    userId: USER_INFO.id,
                    trialTemplateId: examId,
                    started: moment(date).subtract(1, 'hour').toDate(),
                    finished: date,
                    passed: 1,
                    questionCount: EXAMS_INFO[examId].questionCount,
                    allowedFails: EXAMS_INFO[examId].allowedFails,
                    timeLimit: EXAMS_INFO[examId].timeLimit,
                    expired: 1,
                    nullified: 0,
                    sequenceNumber: 1
                }
            }).catch(console.log);

            const trialId = trialData[0].get('id');
            const certData = yield Certificate.findOrCreate({
                where: { trialId },
                defaults: {
                    firstname: USER_INFO.firstname,
                    lastname: USER_INFO.lastname,
                    dueDate: moment(date).add(EXAMS_INFO[examId].validityPeriod, 'month').toDate(),
                    trialId,
                    active: 1,
                    confirmed: 1,
                    confirmedDate: date
                }
            }).catch(console.log);

            const host = `https://yandex.${EXAMS_INFO[examId].lang}/adv/expert/certificates`;

            result.push(`${host}?certId=${certData[0].get('id')}&lastname=${certData[0].get('lastname')}`);
        }
    }

    result.forEach(url => console.log(url));
};

co(function *() {
    yield createCertificates();
});
