const _ = require('lodash');
const fs = require('fs');
const QRcodeController = require('models/draw/qr_code');
const DrawModel = require('models/draw');
const co = require('co');

const FLOW = [
    {
        service: 'direct_base',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Даниил', lastname: 'Салихов' }
        ]
    },
    {
        service: 'direct_pro',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Алесандр', lastname: 'Иванов' }
        ]
    },
    {
        service: 'metrika',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Алексей', lastname: 'Петров' }
        ]
    },
    {
        service: 'cpm',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Василий', lastname: 'Пупкин' }
        ]
    },
    {
        service: 'zen',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Петр', lastname: 'Соловьев' }
        ]
    },
    {
        service: 'rsya',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Генадий', lastname: 'Скворцов' }
        ]
    },
    {
        service: 'direct_cn',
        language: 'cn',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: '璐瑶', lastname: '邢' }
        ]
    },
    {
        service: 'direct_en',
        language: 'en',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'John', lastname: 'Doe' }
        ]
    },
    {
        service: 'metrika_en',
        language: 'en',
        confirmedDate: '2016-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Sergey', lastname: 'Zhigalov' }
        ]
    },
    {
        service: 'market',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: ' Сергей', lastname: 'Жиглов' }
        ]
    },
    {
        service: 'publisher',
        language: 'ru',
        confirmedDate: '2021-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Пётр', lastname: 'Ложкин' }
        ]
    }
];

const DIRECTORY = './scripts/certs';
const FORMATS = [
    'png',
    'pdf'
];

const certDataBuilder = function (stage) {
    return stage.data.map(certData => _.assign(certData, {
        language: stage.language,
        service: stage.service,
        confirmedDate: stage.confirmedDate,
        certId: 190619,
        dueDate: '2022-06-01T12:46:30.135Z',
        type: 'cert'
    }));
};

const writeBufferToFile = function (filename, buffer) {
    if (!buffer) {
        return;
    }

    if (!fs.existsSync(DIRECTORY)) {
        fs.mkdirSync(DIRECTORY);
    }
    fs.writeFileSync(`${DIRECTORY}/${filename}`, buffer);
};

function createCertDifferentModels(drawData, format) {
    co(drawСertAndQr);

    function *drawСertAndQr() {
        const filename = `[${drawData.language}] - ${drawData.firstname} ${drawData.lastname}.${format}`;

        console.log(`start drowing ${filename} for service ${drawData.service}`);

        const qrUrl = yield QRcodeController.createQRcodeUrl(drawData.certId, drawData.lastname, format);

        drawData.qrUrl = qrUrl;

        const { buffer } = DrawModel.drawCert(drawData, format);

        writeBufferToFile(filename, buffer);
        console.log(`finish drowing ${filename} for service ${drawData.service}`);
    }
}

function createCertificates() {
    FLOW.forEach(flow => {
        certDataBuilder(flow).forEach(drawData => {
            FORMATS.forEach(format => {
                createCertDifferentModels(drawData, format);
            });
        });
    });
}

createCertificates();

/*
   {
        service: 'direct_cn',
        language: 'cn',
        confirmedDate: '2016-06-01T12:46:30.135Z',
        data: [
            { firstname: '璐瑶', lastname: '邢' },
            { firstname: 'Suizong', lastname: '测试' },
            { firstname: 'Vasiliy', lastname: 'Pupkin' }
        ]
    },
    {
        service: 'direct',
        language: 'ru',
        confirmedDate: '2016-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Василий', lastname: 'Пупкин' },
            { firstname: 'Vasiliy', lastname: 'Pupkin' },
            { firstname: 'Константин', lastname: 'Константинопольский' }
        ]
    },
    {
        service: 'direct_en',
        language: 'en',
        confirmedDate: '2016-06-01T12:46:30.135Z',
        data: [
            { firstname: 'John', lastname: 'Doe' }
        ]
    },
    {
        service: 'direct',
        language: 'ru',
        confirmedDate: '2015-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Василий', lastname: 'Пупкин' },
            { firstname: 'Константин', lastname: 'Константинопольский' }
        ]
    },
    {
        service: 'direct',
        language: 'en',
        confirmedDate: '2016-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Sergey', lastname: 'Zhigalov' }
        ]
    },
    {
        service: 'unknown_service',
        language: 'en',
        confirmedDate: '2016-06-01T12:46:30.135Z',
        data: [
            { firstname: 'Blog', lastname: 'User' }
        ]
    }
    */
