const db = require('db/postgres');
const { Question, Answer, TrialToQuestion } = db;

const co = require('co');

const tablesToSequences = {
    admins: 'admins_id_seq',
    'admins_to_roles': 'admins_to_roles_id_seq',
    agencies: 'agencies_id_seq',
    answers: 'answers_id_seq',
    'auth_types': 'auth_types_id_seq',
    categories: 'categories_id_seq',
    certificates: 'certificates_id_seq',
    'direct_sync': 'direct_sync_id_seq',
    freezing: 'freezing_id_seq',
    questions: 'questions_id_seq',
    roles: 'roles_id_seq',
    sections: 'sections_id_seq',
    services: 'services_id_seq',
    'trial_template_allowed_fails': 'trial_template_allowed_fails_id_seq',
    'trial_templates': 'trial_templates_id_seq',
    'trial_templates_to_sections': 'trial_templates_to_sections_id_seq',
    trials: 'trials_id_seq',
    types: 'types_id_seq',
    users: 'users_id_seq'
};

const setQuestionVersions = function *() {
    const lastQuestions = yield Question.findAll({
        attributes: [
            'id',
            [db.sequelize.fn('max', db.sequelize.col('version')), 'version']
        ],
        group: ['id'],
        order: [['id']]
    });

    for (const question of lastQuestions) {
        const questionVersion = question.version;
        const questionId = question.id;
        const options = {
            where: { questionId },
            fields: ['questionVersion']
        };

        yield Answer.update({ questionVersion }, options);
        yield TrialToQuestion.update({ questionVersion }, options);
    }
};

const setSequences = function *() {
    yield Object
        .keys(tablesToSequences)
        .map(table => {
            const query = `SELECT setval('${tablesToSequences[table]}',` +
                `COALESCE((SELECT MAX(id)+1 FROM ${table}), 1), false);`;

            return db.sequelize.query(query);
        });
};

co(function *() {
    yield setQuestionVersions();
    yield setSequences();
});
