const co = require('co');
const _ = require('lodash');

const { Certificate, Trial, sequelize } = require('db/postgres');

const findCertificates = function *(transaction) {
    const includeTrials = {
        model: Trial,
        where: { trialTemplateId: { $in: [38, 39] } },
        attributes: []
    };

    const certs = yield Certificate.findAll({
        where: { confirmedDate: { $gt: new Date(2017, 7, 18) } },
        attributes: ['id'],
        include: includeTrials,
        transaction
    });

    return _.map(certs, 'id');
};

const removeImagePaths = function *(transaction) {
    const certIds = yield findCertificates(transaction);

    console.log('CERT_IDS: ', certIds);

    yield Certificate.update(
        { imagePath: null, pdfPath: null },
        {
            where: { id: certIds },
            fields: ['imagePath', 'pdfPath'],
            transaction
        });
};

co(function *() {
    yield sequelize.transaction(co.wrap(removeImagePaths));
});
