const {
    TrialTemplateAllowedFails,
    TrialTemplateToSection,
    Question,
    Answer,
    Trial,
    TrialToQuestion,
    Certificate
} = require('db/postgres');

const co = require('co');

const TRIAL_TEMPLATE_ID = 43;

const getQuestionIds = function *(trialsToSections) {
    const sectionIds = trialsToSections.map(item => item.get('sectionId'));
    const categoryIds = trialsToSections.map(item => item.get('categoryId'));

    const questions = yield Question.findAll({
        where: { sectionId: { $in: sectionIds }, categoryId: { $in: categoryIds } }
    }).catch(console.log);

    let questionIds = [];

    trialsToSections.forEach(item => {
        const sectionId = item.get('sectionId');
        const categoryId = item.get('categoryId');

        const questionsData = questions
            .filter(question => {
                const isSectionIdEquals = question.get('sectionId') === sectionId;
                const isCategoryIdEquals = question.get('categoryId') === categoryId;

                return isSectionIdEquals && isCategoryIdEquals;
            })
            .map(question => question.get('id'));

        questionIds = questionIds.concat(questionsData);
    });

    return questionIds;
};

const removeTrials = function *() {
    const trialsData = yield Trial.findAll({
        where: { trialTemplateId: TRIAL_TEMPLATE_ID },
        attributes: ['id']
    }).catch(console.log);

    const trialIds = trialsData.map(trial => trial.get('id'));

    yield Certificate.destroy({
        where: { trialId: { $in: trialIds } }
    }).catch(console.log);

    yield TrialToQuestion.destroy({
        where: { trialId: { $in: trialIds } }
    }).catch(console.log);

    yield Trial.destroy({
        where: { id: { $in: trialIds } }
    }).catch(console.log);
};

const removeTrialTemplateData = function *() {
    const trialsToSections = yield TrialTemplateToSection.findAll({
        where: { trialTemplateId: TRIAL_TEMPLATE_ID },
        attributes: ['sectionId', 'categoryId']
    }).catch(console.log);

    const questionIds = yield getQuestionIds(trialsToSections);

    yield Answer.destroy({
        where: { questionId: { $in: questionIds } }
    }).catch(console.log);

    yield Question.destroy({
        where: { id: { $in: questionIds } }
    }).catch(console.log);

    yield TrialTemplateToSection.destroy({
        where: { trialTemplateId: TRIAL_TEMPLATE_ID }
    }).catch(console.log);

    yield TrialTemplateAllowedFails.destroy({
        where: { trialTemplateId: TRIAL_TEMPLATE_ID }
    }).catch(console.log);
};

co(function *() {
    yield removeTrials();
    yield removeTrialTemplateData();
});
