const co = require('co');

const {
    Certificate,
    Trial,
    TrialTemplate,
    Type,
    sequelize
} = require('db/postgres');

const getTypes = function *(transaction) {
    const types = yield Type.findAll({
        attributes: ['id'],
        raw: true,
        transaction
    });

    return types.map(type => type.id);
};

const getCertIds = function *(typeId, transaction) {
    const includeTrialTemplate = {
        model: TrialTemplate,
        as: 'trialTemplate',
        where: { typeId },
        attributes: []
    };
    const includeTrial = {
        model: Trial,
        attributes: [],
        include: includeTrialTemplate
    };
    const certs = yield Certificate.findAll({
        attributes: ['id'],
        include: includeTrial,
        transaction
    });

    return certs.map(cert => cert.id);
};

const updateCertType = function *(certIds, typeId, transaction) {
    return yield Certificate.update(
        { typeId },
        {
            where: { id: certIds },
            fields: ['typeId'],
            transaction
        }
    );
};

const updateTypes = function *(transaction) {
    const typeIds = yield getTypes(transaction);

    for (const typeId of typeIds) {
        const certIds = yield getCertIds(typeId, transaction);

        console.log('Cert ids: ', certIds);
        console.log('Type id: ', typeId);

        const [updatedRowsNumber] = yield updateCertType(certIds, typeId, transaction);

        console.log('Updated rows: ', updatedRowsNumber);
    }
};

co(function *() {
    yield sequelize.transaction(co.wrap(updateTypes));

    console.log('Update finished');
});
