const koa = require('koa');
const app = koa();
const router = require('helpers/router-helper')();

const telegramUser = require('middleware/telegramUser');
const token = require('middleware/token');

router
    .useController(require('web/exam'))
    .get('/exam/:identity', 'find', token, telegramUser)

    .useController(require('web/attempt'))
    .post('/attempt/answer', 'answer', token, telegramUser)
    .post('/attempt/:examIdentity', 'create', token, telegramUser)
    .post('/attempt/:attemptId/finish', 'finish', token, telegramUser)
    .post('/attempt/:attemptId/result', 'result', token, telegramUser)
    .get('/attempt/:attemptId/nextQuestion', 'nextQuestion', token, telegramUser)
    .get('/attempt/:examIdentity/check', 'check', token, telegramUser);

app.use(router.routes());

module.exports = app;
