require('co-mocha');

const { expect } = require('chai');

const YaLetterPdf = require(`models/draw/types/ya-letter-pdf`);
const certData = {
    service: 'direct',
    firstname: 'Дмитрий',
    lastname: 'Моруз',
    certId: 555555,
    confirmedDate: '2017-09-09T19:00:00.000Z',
    dueDate: '2018-09-09T19:00:00.000Z',
    language: 'ru',
    type: 'cert',
    isProctoring: false
};

describe('Draw `ya-letter-pdf` model', () => {
    describe('`drawCert`', () => {
        it('should return buffer when format pdf', () => {
            const certModel = new YaLetterPdf(certData, 'pdf');
            const result = certModel.drawCert();

            expect(result.buffer).to.not.be.empty;
            expect(result.buffer).to.be.an.instanceof(Buffer);
        });
    });

    describe('`isSuitable`', () => {
        it('should return true if type is cert and format is pdf', () => {
            const certModel = new YaLetterPdf(certData, 'pdf');

            expect(certModel.isSuitable).to.be.true;
        });

        it('should return false if type is not cert', () => {
            const data = Object.assign({}, certData, {
                type: 'achievement'
            });
            const certModel = new YaLetterPdf(data, 'pdf');

            expect(certModel.isSuitable).to.be.false;
        });

        it('should return false when format png', () => {
            const certModel = new YaLetterPdf(certData, 'png');

            expect(certModel.isSuitable).to.be.false;
        });

        it('should return false if confirmedDate < 18.08.2016', () => {
            const data = Object.assign({}, certData, {
                confirmedDate: '2016-06-01T12:46:30.135Z'
            });
            const certModel = new YaLetterPdf(data, 'pdf');

            expect(certModel.isSuitable).to.be.false;
        });
    });
});
