const Idm = require('models/idm');
const AdminUser = require('models/adminUser');

const AccessControl = require('accessControl/idm');

module.exports = {
    *getInfo() {
        const accessControl = new AccessControl(this.request, this.state);

        accessControl.hasAccess();

        const roles = yield Idm.getActiveRoles();

        return {
            roles: {
                slug: 'expert',
                name: 'Эксперт',
                values: roles
            }
        };
    },

    *getAllRoles() {
        const accessControl = new AccessControl(this.request, this.state);

        accessControl.hasAccess();

        const users = yield Idm.getUsers();

        return { users };
    },

    *addRole() {
        const accessControl = new AccessControl(this.request, this.state);

        accessControl.hasAccess();

        const { body } = this.request;
        const adminUser = yield AdminUser.findOrCreate(body.login, this.ip);

        const role = JSON.parse(body.role);

        return yield Idm.createRole(adminUser, role.expert);
    },

    *removeRole() {
        const accessControl = new AccessControl(this.request, this.state);

        accessControl.hasAccess();

        const { body } = this.request;
        const role = JSON.parse(body.role);

        return yield Idm.removeRole(body.login, role.expert);
    }
};
