const koa = require('koa');
const multer = require('koa-multer')();
const app = koa();
const router = require('helpers/router-helper')();

const idm = require('middleware/idm');
const xlsx = require('middleware/xlsx');

const config = require('yandex-config');
const extWebUser = require('middleware/webUser')(config.blackbox);
const intWebUser = require('middleware/webUser')(config.yandexTeamBlackbox);
const transaction = require('middleware/transaction');
const tvm = require('middleware/tvm');
const karma = require('middleware/karma');
const ban = require('middleware/ban');

router
    .useController(require('./exam'))
    .get('/exam/:identity', 'find', extWebUser)
    .get('/exam/cluster/:slug', 'findByCluster', extWebUser)
    .get('/exam/:identity/lastVersion', 'getLastVersion', intWebUser, transaction)
    .get('/exam/:identity/draft', 'findDraft', intWebUser)
    .post('/exam/:identity/draft', 'saveDraft', intWebUser, transaction)
    .post('/exam/:identity/lock', 'lock', intWebUser, transaction)
    .post('/exam/:identity/unlock', 'unlock', intWebUser, transaction)
    .post('/exam/:identity/settings', 'updateSettings', intWebUser, transaction)
    .delete('/exam/:identity/draft', 'ignoreDraft', intWebUser, transaction)

    .useController(require('./attempt'))
    .post('/attempt/answer', 'answer', extWebUser)
    .post('/attempt/info', 'attemptsInfo', intWebUser)
    .post('/attempt/:examIdentity', 'create', extWebUser, karma, ban, transaction)
    .post('/attempt/:attemptId/finish', 'finish', extWebUser, transaction)
    .post('/attempt/:attemptId/result', 'result', extWebUser, transaction)
    .post('/attempt/:attemptId/needRevision', 'needRevision', multer, transaction)
    .post('/attempt/:attemptId/proctoringMetrics', 'saveProctoringMetrics', extWebUser, transaction)
    .get('/attempt/:attemptId/nextQuestion', 'nextQuestion', extWebUser)
    .get('/attempt/:examIdentity/check', 'check', extWebUser, karma, transaction)
    .get('/attempt/:attemptId/proctoringMetrics', 'getProctoringMetrics', extWebUser)
    .get('/attempt/:attemptId/:questionNumber', 'question', extWebUser)

    .useController(require('./certificate'))
    .post('/certificate/find', 'find', extWebUser)
    .post('/certificates/findByUids', 'findByUids', tvm)
    .post('/certificates/nullify', 'nullify', intWebUser, transaction)
    .post('/certificates/info', 'certificatesInfo', intWebUser)
    .get('/certificates/my', 'myCertificates', extWebUser)
    .get('/certificates/sendToGeoadv', 'sendToGeoadv')
    .get('/certificates/:hashedUserId', 'findAll', extWebUser)
    .get('/certificate/pdf/:hashedUserId/:certId', 'getPdf', extWebUser)

    .useController(require('./idm'))
    .get('/idm/info/', 'getInfo', tvm, idm)
    .get('/idm/get-all-roles/', 'getAllRoles', tvm, idm)
    .post('/idm/add-role/', 'addRole', tvm, idm)
    .post('/idm/remove-role/', 'removeRole', tvm, idm)

    .useController(require('./admin'))
    .get('/admin/downloadXLSX/:examId', 'downloadXLSX', intWebUser, xlsx)
    .get('/admin/downloadJSON/:examIdentity', 'downloadJSON', intWebUser, transaction)
    .get('/admin/agenciesInfo', 'getAgenciesInfo', intWebUser, xlsx)
    .get('/admin', 'getAdminData', intWebUser)
    .get('/admin/report/:reportType', 'report', intWebUser, xlsx)
    .get('/admin/reports', 'reports', intWebUser)
    .get('/admin/videos/:attemptId', 'getVideosData', intWebUser)
    .get('/admin/user/associations', 'getUserAssociations', intWebUser)
    .post('/admin/moderation/exam', 'sendDraftForModeration', intWebUser, transaction)
    .post('/admin/parseXLSX', 'parseXLSX', intWebUser)
    .post('/admin/loadData', 'loadData', intWebUser, transaction)
    .post('/admin/syncAgenciesInfo', 'syncAgenciesInfo', intWebUser)
    .post('/admin/freeze', 'freeze', intWebUser, transaction)
    .post('/admin/unfreeze', 'unfreeze', intWebUser, transaction)
    .post('/admin/proctoring/:attemptId/retry', 'retryProctoring', intWebUser, transaction)
    .post('/admin/appeal', 'appeal', intWebUser, transaction)
    .post('/admin/attempts/nullify', 'nullifyAttempts', intWebUser, transaction)

    .useController(require('./yt'))
    .get('/yt/uploadTrialsToYT', 'uploadTrialsToYT', transaction)
    .get('/yt/loadTolokaResults', 'loadTolokaResults', transaction)
    .get('/yt/uploadStatReports', 'uploadToStat')
    .get('/yt/uploadComdepReport', 'uploadComdepReport')
    .get('/yt/cleanExpiredTables', 'cleanExpiredTables')

    .useController(require('./s3'))
    .get('/s3/uploadFiles', 'uploadFiles')

    .useController(require('./user'))
    .get('/user/takeout/:dir/:name', 'getUserFile', tvm)
    .post('/identification/:examIdentity/photo', 'createPhoto', extWebUser)
    .post('/user/takeout', 'getUserData', tvm)
    .post('/user/ban', 'ban', intWebUser, transaction)
    .post('/user/unban', 'unban', intWebUser, transaction)
    .post('/user/associate', 'associateUsers', intWebUser, transaction)

    .useController(require('./agency'))
    .get('/agencies/syncAgenciesInfo', 'syncAgenciesInfo');

app.use(router.routes());

module.exports = app;
