const { CronJob } = require('cron');
const config = require('yandex-cfg');

const log = require('logger');

/* eslint-disable global-require */
const tryTask = async task => {
    try {
        await require(task.module)(task);
    } catch (err) {
        log.error({ err, task }, 'Failed request to api');
    }
};
/* eslint-enable global-require */

config.tasks.forEach(task => new CronJob({
    cronTime: task.schedule,
    onTick: tryTask.bind(null, task),
    start: true,
    timeZone: config.timeZone
}));

log.info('Cron started');
