'use strict';
const os = require('os');

module.exports = {
    api: {
        version: 'v1'
    },

    router: {
        namespace: '/adv/expert',
        ajax: '/vda/expert'
    },

    server: {
        port: process.env.DEPLOY_HTTP_PORT || 8000,
        hostname: os.hostname()
    },

    static: {
        host: `https://yastatic.net/s3/expert/static/expert-front/${process.env.APP_VERSION}`,
        dir: `${__dirname}/../out/public`
    },

    www: {
        dir: `${__dirname}/../www`,
        options: {
            maxAge: 365 * 24 * 60 * 60 * 1000,
            redirect: false // Защита от OpenRedirect (https://wiki.yandex-team.ru/security/for/developers/#openredirect)
        }
    },

    app: {
        domains: 'com, ru'
    },

    bodyParser: {
        limit: '5mb'
    },

    view: {
        templateRoot: `${__dirname}/../out/static`,
        block: 'b-page',
        templateExt: 'bh',
        cwd: `${__dirname}/../out/static`
    },

    bunker: {
        project: 'expert',
        api: 'http://bunker-api.yandex.net/v1',
        version: 'stable',
        updateInterval: 15 * 60 * 1000,
        retries: 1
    },

    bunkerLang: {
        ru: 'ru',
        by: 'by',
        kz: 'kz',
        ua: 'ua',
        com: 'en',
        'com.tr': 'tr',
        default: 'ru'
    },

    availableLanguages: ['ru', 'en'], // 'ru', 'en', 'uk', 'be', 'kk', 'tt', 'tr'

    langToTld: {
        ru: 'ru',
        en: 'com',
        default: 'ru'
    },

    tldToLang: {
        ru: 'ru',
        com: 'en',
        default: 'ru'
    },

    csp: {
        policies: {
            'default-src': ["'none'"],
            'script-src': ["'self'", "'unsafe-eval'", "'unsafe-inline'", '%nonce%', 'yastatic.net', 'mc.yandex.ru', 'pass.yandex.%tld%', 'mail.yandex.%tld%', 'social.yandex.%tld%'],
            'style-src': ["'self'", "'unsafe-inline'", 'yastatic.net', 'mc.yandex.ru'],
            'font-src': ["'self'", 'yastatic.net'],
            'img-src': ["'self'", 'data:', 'avatars.yandex.net', 'avatars.mds.yandex.net', 'avatars.mdst.yandex.net', 'mc.yandex.ru', 'yastatic.net'],
            'frame-src': [
                "'self'", 'forms.yandex.ru', 'www.youtube.com', 'youtube.com', 'proctoring-no-cookie.commerce-int.yandex.net',
                'proctoring-no-cookie-dev.commerce-int.yandex.net', 'proctoring.expert.yandex.net', 'frontend.vh.yandex.ru',
                'passport.yandex.ru', 'passport.yandex.com'
            ],
            'object-src': ["'self'"],
            'child-src': ["'self'"],
            'connect-src': ["'self'", 'mc.yandex.ru', 'mail.yandex.%tld%', 'sentry-test.iddqd.common.yandex.net', 'sentry.iddqd.common.yandex.net'],
            'frame-ancestors': ["'self'", 'passport.yandex.ru', 'passport.yandex.com']
        },
        useDefaultReportUri: true,
        serviceName: 'expert-front'
    },

    uatraits: {
        server: 'http://uatraits.qloud.yandex.ru',
        skipErrors: true
    },

    uatraitsDefaultValues: {
        isMobile: false,
        BrowserName: 'YandexBrowser'
    },

    morda: {
        ru: 'yandex.ru',
        com: 'yandex.com',
        ua: 'yandex.ua',
        by: 'yandex.ru',
        kz: 'yandex.ru',
        'com.tr': 'yandex.com.tr'
    },

    regions: {
        ru: {
            name: 'Россия'
        },
        com: {
            name: 'Other Countries'
        }
    },

    regionsOrder: ['ru', 'com'],

    passport: {
        protocol: 'https',
        host: tld => `passport.yandex.${tld}`,
        paths: {
            auth: 'auth'
        }
    },

    favicon: {
        ru: '/favicon_ru.ico',
        by: '/favicon_ru.ico',
        kz: '/favicon_ru.ico',
        ua: '/favicon_ru.ico',
        com: '/favicon_en.ico',
        'com.tr': '/favicon_en.ico',
        default: '/favicon_ru.ico'
    },

    share: {
        lib: '//yastatic.net/share2/share.js',
        socialList: 'facebook,vkontakte,odnoklassniki,gplus,twitter,collections'
    },

    forms: {
        subscribeUrl: '/vda/subscribe'
    },

    metrikaCounters: [
        { id: '1207744' }, // Только в этот счетчик отправляются данные с помощью `metrika.reachGoal`
        { id: '7240216' },
        { id: '191494' }
    ],

    badgesSizes: {
        m: {
            width: '230',
            height: '230'
        },
        s: {
            width: '150',
            height: '150'
        },
        inline: {
            width: '275',
            height: '72'
        },
        xs: {
            width: '115',
            height: '115'
        }
    },
    /* eslint-disable camelcase */
    exampleCert: {
        direct_base: {
            orig: 'https://avatars.mds.yandex.net/get-adv/56893/2a0000017c319de153923cd2807322ebd6d6/orig'
        },
        direct_pro: {
            orig: 'https://avatars.mds.yandex.net/get-adv/95093/2a0000017c319cfd2f81e117bac44626792e/orig'
        }
    },
    /**
     * ADD NEW EXAMS HERE ↓
     */

    /* eslint-disable camelcase */
    badges: {
        direct_cn: {
            orig: 'https://avatars.mds.yandex.net/get-adv/114583/2a0000015dbbeb181f1956592501ade11af0/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/42259/2a0000015dbbe710a9e4f94f1e481a2a212a/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/114583/2a0000015dbbeb181f1956592501ade11af0/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/126209/2a0000015dbbec17af33d79f7536c96b974e/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/135342/2a0000015dbbecccbfd82ea872ad85206e57/orig'
        },
        direct_en: {
            orig: 'https://avatars.mds.yandex.net/get-adv/121152/2a00000168a812376a7576ad8dcc63e3325a/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/50237/2a00000168a81958f4f304f010cefdef3940/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/121152/2a00000168a812376a7576ad8dcc63e3325a/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168a8114206deb97df450df78a080/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/121152/2a00000168a80f7b1ce3689b6e580ae093e5/orig'
        },
        metrika_en: {
            orig: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168a81d54f69729abacd3255a0c0b/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168a81dd286d76a0003f7bf0dc9ad/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168a81d54f69729abacd3255a0c0b/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168a81cda6de820c237acaf7d9db9/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168a81c6041c8ad98dc6b194af237/orig'
        },
        direct: {
            orig: 'https://avatars.mds.yandex.net/get-adv/60663/2a0000015dbbeb92d047b752eed0ada6b2d3/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/50237/2a0000015dbbe941454fd87bba823be88a69/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/60663/2a0000015dbbeb92d047b752eed0ada6b2d3/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/42259/2a0000015dbbec741af1c5a0243bbabbef98/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/50237/2a0000015dbbed1bac583914ec14dc24be62/orig'
        },
        direct_base: {
            orig: 'https://avatars.mds.yandex.net/get-adv/118837/2a0000017c129e69d830b43a5ee1eca4b74c/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/50237/2a0000015dbbe941454fd87bba823be88a69/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/60663/2a0000015dbbeb92d047b752eed0ada6b2d3/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/42259/2a0000015dbbec741af1c5a0243bbabbef98/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/50237/2a0000015dbbed1bac583914ec14dc24be62/orig'
        },
        metrika: {
            orig: 'https://avatars.mds.yandex.net/get-adv/50237/2a0000017c0dadffa34b6cd85b76fb400a4b/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/60663/2a0000015dbbedbaef95a996c8efcf4684fa/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/126209/2a0000015dbbee643d58d88dc99919853e22/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/50237/2a0000015dbbeef290aea26b70487d41f285/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/118837/2a0000015dbbef5776a0a1f35efaf792c429/orig'
        },
        market: {
            orig: 'https://avatars.mds.yandex.net/get-adv/28496/2a0000017f78a3210f957e6d32525ce4de4d/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/50995/2a0000015de45c607b2937455ac97db767ac/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/135342/2a0000015de45c8fa6e1803e57c88cfc1c28/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/126209/2a0000015de45d9da648814d80e1ebdde313/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/28496/2a0000015de45dce407473a0ad7be51e5640/orig'
        },
        publisher: {
            orig: 'https://avatars.mds.yandex.net/get-adv/118837/2a0000015e5fee0624df7351cd58fc7056d0/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/28496/2a0000015e5fed04b60097c1eceb22cd5635/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/118837/2a0000015e5fee0624df7351cd58fc7056d0/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/126209/2a0000015e5fee350443ca633aff5eb613bf/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/50995/2a0000015e5feedfc3cbcf81a05fbc8d7f6b/orig'
        },
        rmp: {
            orig: 'https://avatars.mds.yandex.net/get-adv/135342/2a0000015de45c8fa6e1803e57c88cfc1c28/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/50995/2a0000015de45c607b2937455ac97db767ac/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/135342/2a0000015de45c8fa6e1803e57c88cfc1c28/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/126209/2a0000015de45d9da648814d80e1ebdde313/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/28496/2a0000015de45dce407473a0ad7be51e5640/orig'
        },
        rsya: {
            orig: 'https://avatars.mds.yandex.net/get-adv/49890/2a0000017c0daf3050292562cfa76c60843e/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000015de5d57e20be5e75d1efa6ebb32b/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/95093/2a0000015de45cf6ede80a27c9d2394e658b/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/114583/2a0000015de45df817c5b248bdd7db4e5bbc/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/50995/2a0000015de45e28b69997b3240ea162a9a7/orig'
        },
        direct_pro: {
            orig: 'https://avatars.mds.yandex.net/get-adv/60663/2a0000017c129eb3b635100959cca2cf1ae5/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/61206/2a000001662eb2757d948dd1adb3d14908eb/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/121152/2a000001662eb2dfb5afa52a89cbcaf5d2fc/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/50995/2a000001662eb3937b1fe1c600e76058e419/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/118837/2a000001662eb1ed916355c2544db0c0ceac/orig'
        },
        cpm: {
            orig: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000017c0daeeb7e7c91e4e1591abc3efc/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/118837/2a00000168e6013cc319a3babf3f008c232d/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/135342/2a00000168e6022734a2028b71a0943015fa/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/49890/2a00000168e602644ea1f489e94a958eabdc/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/50237/2a00000168e602a8f50e1e70dc27f05aa724/orig'
        },
        zen: {
            orig: 'https://avatars.mds.yandex.net/get-adv/49890/2a0000017c0daf703051852883af723aeadb/orig',
            inline: 'https://avatars.mds.yandex.net/get-adv/50237/2a00000173ed31d76ea07fda81f41acd3a7f/orig',
            m: 'https://avatars.mds.yandex.net/get-adv/49643/2a00000173ed3258db542e73e6afe0fe941a/orig',
            s: 'https://avatars.mds.yandex.net/get-adv/95093/2a00000173ed32f60b57163edbf5da08b0db/orig',
            xs: 'https://avatars.mds.yandex.net/get-adv/28496/2a00000173ed335e49a158275ccda4236093/orig'
        },
        hello: {
            orig: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000017c12ba58f90ee89462688ec4ba9b/orig'
        }
    },

    examSlugToServiceCode: {
        'direct-cn': 'direct',
        'direct-en': 'direct',
        'metrica-en': 'metrika',
        direct: 'direct',
        'direct-base': 'direct_base',
        metrika: 'metrika',
        'market-base': 'market',
        publisher: 'publisher',
        rmp: 'rmp',
        rsya: 'rsya',
        'direct-pro': 'direct_pro',
        cpm: 'cpm',
        zen: 'zen',
        msp: 'msp'
    },

    examSlugToMaterialCode: {
        cpm: 'cpm',
        'direct-pro': 'direct',
        'direct-base': 'direct',
        'market-base': 'market',
        metrika: 'metrika',
        publisher: 'publisher',
        rmp: 'rmp',
        rsya: 'rsya',
        zen: 'zen',
        msp: 'msp'
    },

    specificExamLangs: {
        // FIXME: EXPERTDEV-668
        // 'direct-cn': 'zh-Hans'
    },

    certLangs: {
        direct_cn: 'en',
        direct_en: 'en',
        metrika_en: 'en',
        direct: 'ru',
        direct_base: 'ru',
        market: 'ru',
        metrika: 'ru',
        rsya: 'ru',
        direct_pro: 'ru',
        cpm: 'ru',
        zen: 'ru'
    },

    tldForExamSlugs: {
        direct: 'ru',
        'direct-pro': 'ru',
        'direct-base': 'ru',
        metrika: 'ru',
        'market-base': 'ru',
        publisher: 'ru',
        rsya: 'ru',
        hello: 'ru',
        cpm: 'ru',
        zen: 'ru',
        msp: 'ru',
        rmp: 'ru',
        'direct-en': 'com',
        'direct-cn': 'com',
        'metrica-en': 'com'
    },

    hiddenExams: ['msp'],

    /**
     * ADD NEW EXAMS HERE ↑
     */

    pendingImage: {
        w600: 'https://avatars.mds.yandex.net/get-expert/149101/pending-cert/w600',
        orig: 'https://avatars.mds.yandex.net/get-expert/149101/pending-cert/orig'
    },

    certPopups: {
        en: 'https://avatars.mds.yandex.net/get-adv/56893/2a0000015e02f64c1fd1cbb872a6d49e813e/orig',
        ru: 'https://avatars.mds.yandex.net/get-adv/135342/2a0000015e0304c42fafed9fe0645d9382ed/orig'
    },

    certPopupSize: {
        width: 130,
        height: 184
    },

    // Дата введения сертификации ya-letter
    yaLetterCertificationDate: new Date(2017, 7, 18),

    // id форм для обратной связи по прокторингу
    proctoringForms: {
        identification: '8899',
        attempt: '8879',
        'attempt-result': {
            support: '10013654',
            toloka: '10013653'
        }
    },

    proctoringSupportBrowsers:
        [
            { name: 'chrom', version: '72' },
            { name: 'opera', version: '59' },
            { name: 'yandex', version: '19.3' }
        ],

    proctoringJwtSecret: process.env.JWT_PROCTORING_SECRET,

    proctoringMaxErrorLevel: 3,

    proctoringIframeUrl: {
        protocol: 'https',
        host: 'proctoring-no-cookie-dev.commerce-int.yandex.net',
        pathname: '/supervisor'
    },

    sentry: {
        public: process.env.SENTRY_DSN,
        private: process.env.SENTRY_PRIVATE_DSN,
        useContext: true
    },

    blackbox: {
        getServiceTicket: req => {
            if (req.tvm && req.tvm.tickets && req.tvm.tickets.blackbox) {
                return req.tvm.tickets.blackbox.ticket;
            }
        }
    },

    tvm: {
        options: {
            destinations: ['blackbox'],
            serverUrl: `${process.env.DEPLOY_TVM_TOOL_URL}/tvm`,
            token: process.env.TVMTOOL_LOCAL_AUTHTOKEN
        }
    },

    logger: {
        excludedServices: ['uatraits', 'localhost']
    }
};
