'use strict';

module.exports = {
    api: {
        host: 'http://expert-api-development.commerce-int.yandex.ru'
    },

    static: {
        host: '/adv/expert/static',
        dir: `${__dirname}/../static`
    },

    view: {
        templateRoot: `${__dirname}/../static`,
        cwd: `${__dirname}/../static`,
        dev: true
    },

    bunker: {
        api: 'http://bunker-api-dot.yandex.net/v1',
        version: 'latest',
        updateInterval: 30000
    },

    blackbox: {
        api: 'pass-test.yandex.ru',
        getServiceTicket: () => {}
    },

    tvm: {
        options: {
            destinations: [],
            serverUrl: 'http://localhost:8001',
            token: ''
        }
    },

    passport: {
        host: tld => `passport-test.yandex.${tld}`
    },

    host: 'https://localhost.msup.yandex.',

    tldForExamSlugs: {
        vip: 'ru'
    },

    examSlugToServiceCode: {
        vip: 'direct',
        simple: 'direct',
        'hello-pro': 'direct',
        'simple-en': 'direct',
        'simple-cn': 'direct'
    },

    logger: {
        excludedServices: ['uatraits', 'bunker', 'pass-test']
    }
};
